# 📋 دليل استخدام نظام رفع المستخدمين الجماعي

## ✅ تم الانتهاء من التنفيذ بنجاح!

تم إنشاء نظام احترافي متكامل لرفع المستخدمين (الطلاب) من ملفات Excel مع جميع الميزات المطلوبة.

---

## 🎯 الميزات المُنفَّذة

### ✅ رفع الملفات
- دعم ملفات Excel (.xlsx, .xls) و CSV
- رفع بالسحب والإفلات (Drag & Drop)
- حد أقصى 10MB للملف
- معالجة 500-1000 طالب في المرة الواحدة

### ✅ معاينة وتأكيد البيانات
- عرض أول 5 صفوف للمعاينة
- Mapping يدوي للأعمدة مع تخمين ذكي تلقائي
- خيار تحديث المستخدمين الموجودين
- خيار تخطي الأخطاء والمتابعة

### ✅ المعالجة
- معالجة على دفعات (100 طالب في الدفعة)
- استخدام Transactions لضمان سلامة البيانات
- إنشاء مستخدمين جدد أو تحديث الموجودين
- تسجيل في الكورسات والمجموعات تلقائياً
- معالجة أرقام الهواتف الكاملة (بدون صفر)

### ✅ التقارير الشاملة
- عدد الطلاب الجدد
- عدد الطلاب المُحدَّثين مع تفاصيل البيانات المُحدَّثة
- عدد التسجيلات في الكورسات
- عدد الإضافات للمجموعات
- قائمة تفصيلية بالأخطاء
- معدل النجاح والفشل
- تحميل ملف الأخطاء (Excel)

---

## 📂 البنية المُنشأة

### 1. قاعدة البيانات
**الجدول:** `bulk_import_sessions`

| الحقل | النوع | الوصف |
|------|------|-------|
| id | BIGINT | المعرّف الفريد |
| uploaded_by | FK | معرّف المستخدم الذي رفع الملف |
| file_name | VARCHAR | اسم الملف |
| file_path | VARCHAR | مسار الملف |
| total_rows | INT | إجمالي الصفوف |
| new_users | INT | عدد المستخدمين الجدد |
| updated_users | INT | عدد المستخدمين المُحدَّثين |
| skipped_rows | INT | عدد الصفوف المتخطاة |
| failed_rows | INT | عدد الأخطاء |
| enrollments_created | INT | عدد التسجيلات في الكورسات |
| group_members_added | INT | عدد الإضافات للمجموعات |
| updated_users_details | JSON | تفاصيل المُحدَّثين |
| new_users_details | JSON | تفاصيل الجدد |
| errors | JSON | قائمة الأخطاء |
| mapping | JSON | ربط الأعمدة |
| status | ENUM | الحالة (pending, processing, completed, failed) |
| started_at | TIMESTAMP | وقت البدء |
| completed_at | TIMESTAMP | وقت الانتهاء |

### 2. الملفات المُنشأة

#### Migration
```
database/migrations/2025_11_28_203735_create_bulk_import_sessions_table.php
```

#### Model
```
app/Models/BulkImportSession.php
```

#### Service
```
app/Services/BulkImportService.php
```

#### Controller
```
app/Http/Controllers/Admin/BulkUserImportController.php
```

#### Views
```
resources/views/admin/pages/users/bulk-import/
├── index.blade.php      (صفحة رفع الملف)
├── preview.blade.php    (معاينة والـ mapping)
└── report.blade.php     (التقرير النهائي)
```

---

## 🚀 طريقة الاستخدام

### الخطوة 1: الوصول للنظام
```
URL: http://127.0.0.1:8000/admin/users/bulk-import
```

### الخطوة 2: تحميل القالب
1. اضغط على زر **"تحميل القالب"**
2. سيتم تحميل ملف Excel يحتوي على:
   - Sheet التعليمات (شرح كامل)
   - Sheet البيانات (مع أمثلة جاهزة)

### الخطوة 3: تعبئة البيانات

#### الأعمدة المطلوبة:

| العمود | مطلوب؟ | الوصف | مثال |
|--------|---------|-------|------|
| name | ✅ نعم | اسم الطالب | أحمد محمد |
| email | ✅ نعم | البريد الإلكتروني (فريد) | ahmad@example.com |
| password | ✅ نعم | كلمة المرور | 123456 |
| full_phone | ❌ لا | رقم الهاتف كامل بدون + أو 0 | 966512345678 |
| course_name | ❌ لا | اسم الكورس (مطابق للنظام) | Laravel للمبتدئين |
| group_name | ❌ لا | اسم المجموعة (مطابق للنظام) | المجموعة أ |

#### ملاحظات مهمة:
- البريد الإلكتروني يجب أن يكون فريداً
- رقم الهاتف يُكتب كاملاً: `966512345678` (بدون + وبدون صفر في البداية)
- إذا كان الطالب موجوداً (نفس البريد)، سيتم **تحديث بياناته**
- اسم الكورس والمجموعة يجب أن يكون **مطابقاً تماماً** للاسم في النظام

### الخطوة 4: رفع الملف
1. اختر الملف من جهازك
2. أو اسحبه وأفلته في المنطقة المخصصة
3. اضغط **"رفع الملف والمتابعة"**

### الخطوة 5: المعاينة والـ Mapping
1. سيتم عرض أول 5 صفوف للمراجعة
2. تحقق من ربط الأعمدة (Mapping):
   - Column A → name
   - Column B → email
   - Column C → password
   - إلخ...
3. النظام يقوم بالتخمين الذكي تلقائياً
4. يمكنك تعديل الربط يدوياً إذا لزم الأمر
5. حدد الخيارات:
   - ✅ **تحديث المستخدمين الموجودين** (مُفعَّل افتراضياً)
   - ✅ **تخطي الأخطاء والمتابعة** (مُفعَّل افتراضياً)
6. اضغط **"بدء المعالجة"**

### الخطوة 6: المعالجة
- سيتم معالجة جميع الصفوف
- المعالجة تتم على دفعات (100 صف في المرة)
- استخدام Transactions لضمان سلامة البيانات

### الخطوة 7: مراجعة التقرير
سيتم عرض تقرير شامل يحتوي على:

#### 📊 إحصائيات
- ✅ عدد الطلاب الجدد
- 🔄 عدد الطلاب المُحدَّثين
- 📚 عدد التسجيلات في الكورسات
- 👥 عدد الإضافات للمجموعات
- ❌ عدد الأخطاء
- ⏭️ عدد الصفوف المتخطاة

#### 📋 قوائم تفصيلية
1. **قائمة الطلاب الجدد:**
   - الاسم، البريد، الكورس، المجموعة

2. **قائمة الطلاب المُحدَّثين:**
   - الاسم، البريد، البيانات المُحدَّثة (الاسم، الهاتف، كلمة المرور)

3. **قائمة الأخطاء:**
   - رقم الصف، البريد، رسالة الخطأ

#### 💾 خيارات التحميل
- **تحميل ملف الأخطاء** (إذا وجدت أخطاء)
- **عرض المستخدمين**
- **رفع ملف جديد**

---

## 🔧 التفاصيل التقنية

### معالجة أرقام الهواتف

النظام يدعم رموز الدول التالية تلقائياً:
```
966 → +966 (السعودية)
971 → +971 (الإمارات)
20  → +20  (مصر)
962 → +962 (الأردن)
965 → +965 (الكويت)
973 → +973 (البحرين)
974 → +974 (قطر)
968 → +968 (عمان)
... والمزيد
```

**مثال:**
```
Input:  966512345678
Output:
  country_code: +966
  phone: 512345678
  full_phone: +966512345678
```

### التعامل مع المستخدمين الموجودين

عند العثور على بريد إلكتروني موجود:

#### إذا كان خيار "تحديث الموجودين" مُفعَّل:
```php
// سيتم تحديث:
- الاسم (إذا تغير)
- كلمة المرور (يتم تشفيرها)
- رقم الهاتف (إذا تغير)

// سيتم تسجيل:
- البيانات المُحدَّثة
- عدد +1 للـ updated_users
```

#### إذا كان الخيار غير مُفعَّل:
```php
// سيتم:
- تخطي هذا الطالب
- عدد +1 للـ skipped_rows
```

### التسجيل في الكورسات

```php
// عند وجود course_name:
1. البحث عن الكورس بالاسم
2. التحقق من عدم التسجيل المسبق
3. إنشاء CourseEnrollment
4. تعيين:
   - enrollment_status = 'active'
   - completion_percentage = 0
   - enrollment_date = now()
```

### الإضافة للمجموعات

```php
// عند وجود group_name:
1. البحث عن المجموعة بالاسم
2. التحقق من max_members
3. التحقق من عدم العضوية المسبقة
4. إنشاء CourseGroupMember
5. تعيين role = 'member'
```

### الأدوار (Roles)

جميع المستخدمين الجدد يتم تعيين role **"student"** لهم تلقائياً:
```php
$user->assignRole('student');
```

---

## 🎨 Routes المُضافة

| Method | URI | Name | الوصف |
|--------|-----|------|-------|
| GET | `/admin/users/bulk-import` | users.bulk-import.index | صفحة الرفع |
| POST | `/admin/users/bulk-import/upload` | users.bulk-import.upload | رفع الملف |
| GET | `/admin/users/bulk-import/preview` | users.bulk-import.preview | المعاينة |
| POST | `/admin/users/bulk-import/process` | users.bulk-import.process | المعالجة |
| GET | `/admin/users/bulk-import/report/{session}` | users.bulk-import.report | التقرير |
| GET | `/admin/users/bulk-import/download-template` | users.bulk-import.template | تحميل القالب |
| GET | `/admin/users/bulk-import/download-errors/{session}` | users.bulk-import.errors | تحميل الأخطاء |

---

## 📝 أمثلة عملية

### مثال 1: رفع 3 طلاب جدد
```excel
name          | email              | password | full_phone    | course_name        | group_name
أحمد محمد     | ahmad@example.com  | 123456   | 966512345678  | Laravel للمبتدئين | المجموعة أ
سارة علي      | sara@example.com   | pass2024 | 966501234567  | PHP المتقدم        | المجموعة ب
خالد حسن      | khaled@example.com | secure   | 971501234567  |                    |
```

**النتيجة:**
- ✅ 3 طلاب جدد
- 📚 2 تسجيلات في كورسات
- 👥 2 إضافات لمجموعات

### مثال 2: تحديث بيانات طالب موجود
```excel
name          | email              | password | full_phone
أحمد محمود    | ahmad@example.com  | newpass  | 966555555555
```

**النتيجة** (إذا كان ahmad@example.com موجوداً):
- 🔄 1 طالب مُحدَّث
- ✓ الاسم: من "أحمد محمد" إلى "أحمد محمود"
- ✓ كلمة المرور: تم التحديث
- ✓ رقم الهاتف: تم التحديث

### مثال 3: أخطاء شائعة
```excel
name     | email       | password | course_name
أحمد     | invalid     | 123      | كورس غير موجود
```

**النتيجة:**
- ❌ خطأ في الصف 2: "البريد الإلكتروني غير صحيح"
- ❌ خطأ في الصف 2: "الكورس 'كورس غير موجود' غير موجود"

---

## 🔒 الأمان

### التحقق والـ Validation
```php
- name: required|string|max:255
- email: required|email|unique (أو ignore للتحديث)
- password: required|string|min:6
- full_phone: nullable|string|max:20
- course_name: nullable|string|exists:courses,name
- group_name: nullable|string|exists:course_groups,name
```

### التشفير
```php
// جميع كلمات المرور يتم تشفيرها تلقائياً
Hash::make($password)
```

### Transactions
```php
// كل 100 صف يتم معالجتهم في Transaction واحد
DB::beginTransaction();
try {
    // معالجة الصفوف...
    DB::commit();
} catch (\Exception $e) {
    DB::rollback();
}
```

### الصلاحيات
```php
// فقط المستخدمين ذوي role "admin" يمكنهم الوصول
->middleware(['auth', 'role:admin'])
```

---

## ✅ الاختبار

### اختبار سريع:
1. افتح: `http://127.0.0.1:8000/admin/users/bulk-import`
2. اضغط "تحميل القالب"
3. افتح الملف وستجد 3 أمثلة جاهزة
4. ارفع الملف مباشرة (بدون تعديل)
5. راجع المعاينة واضغط "بدء المعالجة"
6. تحقق من التقرير

### التحقق من قاعدة البيانات:
```sql
-- التحقق من الجدول الجديد
SELECT * FROM bulk_import_sessions;

-- التحقق من المستخدمين الجدد
SELECT * FROM users WHERE created_at > NOW() - INTERVAL 5 MINUTE;
```

---

## 🎉 تم الانتهاء!

النظام جاهز للاستخدام بالكامل مع جميع الميزات المطلوبة:
- ✅ رفع ملفات Excel/CSV
- ✅ معاينة البيانات قبل الرفع
- ✅ Mapping يدوي للأعمدة
- ✅ تحديث المستخدمين الموجودين تلقائياً
- ✅ تقرير شامل مفصل
- ✅ دعم أرقام الهواتف الكاملة
- ✅ التسجيل في الكورسات والمجموعات
- ✅ تحميل قالب Excel جاهز
- ✅ معالجة 500-1000 طالب بكفاءة

**استمتع بالنظام! 🚀**
