# 🔄 تكامل n8n ثنائي الاتجاه - دليل شامل

## ✅ نعم، النظام يدعم الإرسال والاستقبال 100%

---

## 📤 الإرسال (Laravel → n8n)

### كيف يعمل:

1. **حدث يحدث في النظام** (مثل: تسجيل طالب، إكمال كورس، إلخ)
2. **Event يتم dispatch**:
   ```php
   event(new N8nWebhookEvent('student.enrolled', [...data...]));
   ```
3. **N8nWebhookListener** يستقبل الحدث تلقائياً
4. **N8nWebhookService** يبحث عن Endpoints النشطة للحدث
5. **SendWebhookToN8n Job** يتم إرساله إلى Queue
6. **HTTP POST** يتم إرساله إلى n8n مع:
   - HMAC Signature
   - Headers مخصصة
   - Payload كامل
7. **النتيجة** يتم تسجيلها في `outgoing_webhook_logs`

### الأحداث المدعومة (9 أحداث):

1. ✅ `student.enrolled` - تسجيل طالب في كورس
2. ✅ `student.unenrolled` - إلغاء تسجيل طالب
3. ✅ `user.registered` - تسجيل مستخدم جديد
4. ✅ `lesson.completed` - إكمال درس
5. ✅ `course.completed` - إكمال كورس
6. ✅ `quiz.completed` - إكمال اختبار
7. ✅ `course.review.created` - إنشاء مراجعة
8. ✅ `course.published` - نشر كورس
9. ✅ `certificate.issued` - إصدار شهادة

### الإعداد:

1. اذهب إلى `/admin/n8n/endpoints/create`
2. أضف URL الخاص بـ n8n webhook
3. اختر نوع الحدث (أو `*` للكل)
4. أضف Secret Key (اختياري)
5. فعّل Endpoint

---

## 📥 الاستقبال (n8n → Laravel)

### كيف يعمل:

1. **n8n يرسل HTTP POST** إلى:
   ```
   POST /api/webhooks/n8n/incoming
   ```
2. **Middleware** يتحقق من Signature/API Key
3. **N8nWebhookController** يستقبل الطلب
4. **N8nIncomingWebhookService** يعالج:
   - يبحث عن Handler المناسب
   - يتحقق من الحقول المطلوبة
   - ينفذ Handler
5. **Handler** ينفذ العملية المطلوبة
6. **JSON Response** يتم إرجاعه إلى n8n

### Handlers المتاحة (9 handlers):

1. ✅ `create_user` - إنشاء مستخدم جديد
   - Handler: `App\Webhooks\N8n\Handlers\CreateUserHandler`
   - الحقول المطلوبة: `name`, `email`
   - الحقول الاختيارية: `phone`, `password`, `role`, `bio`

2. ✅ `update_user` - تحديث مستخدم
   - Handler: `App\Webhooks\N8n\Handlers\UpdateUserHandler`
   - الحقول المطلوبة: `user_id` أو `email`
   - الحقول الاختيارية: `name`, `phone`, `bio`

3. ✅ `enroll_student` - تسجيل طالب في كورس
   - Handler: `App\Webhooks\N8n\Handlers\EnrollStudentHandler`
   - الحقول المطلوبة: `student_id` أو `student_email`, `course_id` أو `course_slug`
   - الحقول الاختيارية: `enrollment_status`

4. ✅ `unenroll_student` - إلغاء تسجيل طالب
   - Handler: `App\Webhooks\N8n\Handlers\UnenrollStudentHandler`
   - الحقول المطلوبة: `student_id` أو `student_email`, `course_id` أو `course_slug`

5. ✅ `update_grade` - تحديث درجة طالب
   - Handler: `App\Webhooks\N8n\Handlers\UpdateGradeHandler`
   - الحقول المطلوبة: `student_id`, `course_id`, `grade`
   - الحقول الاختيارية: `grade_percentage`, `notes`

6. ✅ `send_notification` - إرسال إشعار
   - Handler: `App\Webhooks\N8n\Handlers\SendNotificationHandler`
   - الحقول المطلوبة: `user_id` أو `user_email`, `title`, `message`
   - الحقول الاختيارية: `type`, `icon`, `action_url`

7. ✅ `send_telegram` - إرسال رسالة Telegram
   - Handler: `App\Webhooks\N8n\Handlers\SendTelegramHandler`
   - الحقول المطلوبة: `chat_id`, `message`
   - الحقول الاختيارية: `parse_mode`, `reply_markup`

8. ✅ `send_whatsapp` - إرسال رسالة WhatsApp
   - Handler: `App\Webhooks\N8n\Handlers\SendWhatsAppHandler`
   - الحقول المطلوبة: `phone`, `message`
   - الحقول الاختيارية: `template`, `variables`

9. ✅ `base_handler` - Handler أساسي (للتطوير)

### الإعداد:

1. اذهب إلى `/admin/n8n/handlers`
2. تأكد من وجود Handlers النشطة
3. في n8n، أضف HTTP Request Node:
   - URL: `https://your-domain.com/api/webhooks/n8n/incoming`
   - Method: `POST`
   - Headers:
     - `X-Handler-Type`: `create_user` (مثال)
     - `Content-Type`: `application/json`
   - Body: JSON مع البيانات المطلوبة

### مثال على Request من n8n:

```json
POST /api/webhooks/n8n/incoming
Headers:
  X-Handler-Type: create_user
  X-N8N-Signature: <HMAC signature>
  X-Webhook-Timestamp: <timestamp>
  Content-Type: application/json

Body:
{
  "name": "أحمد محمد",
  "email": "ahmed@example.com",
  "phone": "+966501234567",
  "role": "student"
}
```

### Response من Laravel:

```json
{
  "success": true,
  "message": "User created successfully",
  "data": {
    "user_id": 123,
    "name": "أحمد محمد",
    "email": "ahmed@example.com"
  }
}
```

---

## 🔐 الأمان

### للإرسال (Laravel → n8n):

- ✅ HMAC Signature (SHA256)
- ✅ Timestamp validation
- ✅ Secret Key encryption في قاعدة البيانات
- ✅ Custom Headers support
- ✅ SSL verification (قابل للتعديل)

### للاستقبال (n8n → Laravel):

- ✅ HMAC Signature verification
- ✅ API Key fallback
- ✅ IP Whitelist (اختياري)
- ✅ Payload validation
- ✅ Required fields check

---

## 📊 API Endpoints

### للاستقبال:

1. **POST** `/api/webhooks/n8n/incoming`
   - استقبال webhook من n8n
   - Headers: `X-Handler-Type` أو `handler_type` في Body

2. **GET** `/api/webhooks/n8n/handlers`
   - الحصول على قائمة Handlers المتاحة
   - Response: JSON مع جميع Handlers النشطة

3. **GET** `/api/webhooks/n8n/handlers/{handlerType}`
   - الحصول على توثيق Handler محدد
   - Response: JSON مع التوثيق الكامل

---

## 🎯 أمثلة عملية

### مثال 1: إنشاء مستخدم من n8n

**في n8n:**
```json
POST https://your-domain.com/api/webhooks/n8n/incoming
Headers:
  X-Handler-Type: create_user
  Content-Type: application/json

Body:
{
  "name": "محمد علي",
  "email": "mohammed@example.com",
  "phone": "+966501234567",
  "role": "student"
}
```

**النتيجة:**
- ✅ يتم إنشاء مستخدم جديد في Laravel
- ✅ يتم تعيين Role تلقائياً
- ✅ يتم إرجاع Response مع `user_id`

---

### مثال 2: تسجيل طالب في كورس من n8n

**في n8n:**
```json
POST https://your-domain.com/api/webhooks/n8n/incoming
Headers:
  X-Handler-Type: enroll_student

Body:
{
  "student_email": "student@example.com",
  "course_slug": "web-development-basics",
  "enrollment_status": "active"
}
```

**النتيجة:**
- ✅ يتم البحث عن الطالب والكورس
- ✅ يتم تسجيل الطالب في الكورس
- ✅ يتم إرسال Event `student.enrolled` تلقائياً (إلى n8n مرة أخرى إذا كان هناك endpoint)

---

### مثال 3: إرسال إشعار من n8n

**في n8n:**
```json
POST https://your-domain.com/api/webhooks/n8n/incoming
Headers:
  X-Handler-Type: send_notification

Body:
{
  "user_email": "student@example.com",
  "title": "مرحباً بك!",
  "message": "تم تفعيل حسابك بنجاح",
  "type": "info",
  "action_url": "/dashboard"
}
```

**النتيجة:**
- ✅ يتم إرسال إشعار داخلي للمستخدم
- ✅ يظهر في لوحة تحكم المستخدم
- ✅ يمكن إرسال Email أيضاً

---

## 🔄 التكامل الكامل (Bidirectional)

### سيناريو كامل:

1. **n8n** يرسل طلب إنشاء مستخدم → **Laravel** يستقبل وينشئ
2. **Laravel** يرسل Event `user.registered` → **n8n** يستقبل
3. **n8n** يرسل طلب تسجيل في كورس → **Laravel** يستقبل ويسجل
4. **Laravel** يرسل Event `student.enrolled` → **n8n** يستقبل
5. **الطالب** يكمل الكورس → **Laravel** يرسل Event `course.completed` → **n8n** يستقبل
6. **Laravel** يصدر شهادة → **Laravel** يرسل Event `certificate.issued` → **n8n** يستقبل
7. **n8n** يرسل إشعار تهنئة → **Laravel** يستقبل ويرسل للمستخدم

---

## 📋 Checklist للتكامل الكامل

### ✅ الإرسال (Laravel → n8n):
- ✅ Events تم إضافتها (9 أحداث)
- ✅ N8nWebhookListener مسجل
- ✅ N8nWebhookService يعمل
- ✅ SendWebhookToN8n Job موجود
- ✅ Queue system جاهز
- ✅ Retry logic موجود
- ✅ Logging كامل

### ✅ الاستقبال (n8n → Laravel):
- ✅ API Endpoint موجود (`/api/webhooks/n8n/incoming`)
- ✅ Middleware للتحقق من Signature
- ✅ N8nIncomingWebhookService يعمل
- ✅ 9 Handlers جاهزة
- ✅ Validation موجود
- ✅ Error handling كامل
- ✅ Documentation API موجود

---

## 🚀 الخطوات التالية

1. **إعداد Queue Worker**:
   ```bash
   php artisan queue:work --queue=webhooks --tries=3
   ```

2. **إضافة Endpoints في لوحة التحكم**:
   - `/admin/n8n/endpoints/create`
   - أضف URL الخاص بـ n8n

3. **إضافة Handlers في لوحة التحكم** (إذا لم تكن موجودة):
   - `/admin/n8n/handlers/create`
   - أو استخدم Seeder الموجود

4. **اختبار التكامل**:
   - أرسل Event من Laravel → تحقق من n8n
   - أرسل Request من n8n → تحقق من Laravel

---

## ✅ الخلاصة

**النظام يدعم الإرسال والاستقبال 100%** ✅

### 📤 الإرسال (Laravel → n8n):
- ✅ **9 أحداث** جاهزة للإرسال التلقائي
- ✅ **Queue System** للعمل غير المتزامن
- ✅ **Retry Logic** للأحداث الفاشلة
- ✅ **HMAC Signature** للأمان
- ✅ **Logging** كامل في قاعدة البيانات

### 📥 الاستقبال (n8n → Laravel):
- ✅ **9 Handlers** جاهزة للاستقبال
- ✅ **API Endpoint** `/api/webhooks/n8n/incoming`
- ✅ **Validation** للحقول المطلوبة
- ✅ **Error Handling** كامل
- ✅ **Documentation API** للتوثيق
- ✅ **Flexible Identification** (يدعم ID, Email, Slug, Code)

### 🔐 الأمان:
- ✅ **HMAC Signature** verification
- ✅ **API Key** fallback
- ✅ **IP Whitelist** (اختياري)
- ✅ **Payload Validation**
- ✅ **Secret Key Encryption** في قاعدة البيانات

### 🎯 الميزات:
- ✅ **Bidirectional** - إرسال واستقبال كامل
- ✅ **Event-driven** - أحداث تلقائية
- ✅ **Queue-based** - عمل غير متزامن
- ✅ **Retry Support** - إعادة المحاولة التلقائية
- ✅ **Comprehensive Logging** - سجلات كاملة
- ✅ **Admin Panel** - إدارة كاملة من لوحة التحكم

**النظام جاهز للعمل ثنائي الاتجاه مع n8n!** 🎉

**تاريخ التحديث**: 2025-12-03

