# 📱 دليل استخدام نظام الهاتف و WhatsApp

## ✅ تم التنفيذ بنجاح!

تم إضافة نظام متكامل لإدخال رقم الهاتف مع اختيار رمز الدولة والتكامل مع WhatsApp.

---

## 🎯 المميزات

### 1. **اختيار رمز الدولة التلقائي**
- 🌍 مكتبة `intl-tel-input` للاختيار من 200+ دولة
- 🇸🇦 السعودية كافتراضي
- 🎨 واجهة جميلة وسهلة الاستخدام
- ✅ التحقق التلقائي من صحة الرقم

### 2. **تخزين ذكي**
يتم تخزين 3 حقول في قاعدة البيانات:
- `country_code`: رمز الدولة (مثل: +966)
- `phone`: رقم الهاتف بدون الرمز (مثل: 512345678)
- `full_phone`: الرقم الكامل بالصيغة الدولية (مثل: +966512345678)

### 3. **تكامل WhatsApp**
يتم إنشاء رابط WhatsApp تلقائياً لكل مستخدم:
```php
$user->whatsapp_url; // https://wa.me/966512345678
$user->whatsapp_number; // 966512345678
```

---

## 📊 هيكل قاعدة البيانات

```sql
-- تمت إضافة الأعمدة التالية لجدول users:
country_code VARCHAR(5) NULL     -- رمز الدولة
phone VARCHAR(20) NULL            -- رقم الهاتف
full_phone VARCHAR(25) NULL       -- الرقم الكامل (للبحث والتحقق)
```

---

## 🎨 كيفية الاستخدام

### 1. إضافة مستخدم جديد
```
http://127.0.0.1:8000/admin/users/create
```

1. املأ البيانات الأساسية (الاسم، البريد الإلكتروني)
2. في حقل **رقم الهاتف (WhatsApp)**:
   - اختر الدولة من القائمة المنسدلة (السعودية افتراضياً)
   - أدخل رقم الهاتف بدون رمز الدولة
   - مثال: `512345678`
3. سيتم تخزين:
   - Country Code: `+966`
   - Phone: `512345678`
   - Full Phone: `+966512345678`

### 2. استخدام رقم WhatsApp في التطبيق

#### في Blade Templates:
```blade
@if($user->full_phone)
    <a href="{{ $user->whatsapp_url }}" target="_blank" class="btn btn-success">
        <i class="fab fa-whatsapp"></i> تواصل عبر WhatsApp
    </a>
@endif
```

#### في Controllers:
```php
// الحصول على رابط WhatsApp
$whatsappUrl = $user->whatsapp_url;

// إرسال رسالة مباشرة عبر WhatsApp
$message = urlencode("مرحباً {$user->name}!");
$link = "{$user->whatsapp_url}?text={$message}";
```

#### مع n8n Webhooks:
```php
// إرسال رقم WhatsApp مع البيانات
event(new N8nWebhookEvent('student.enrolled', [
    'student_id' => $student->id,
    'student_name' => $student->name,
    'whatsapp_number' => $student->whatsapp_number, // 966512345678
    'whatsapp_url' => $student->whatsapp_url,
    'course_name' => $course->name,
]));
```

---

## 🔍 أمثلة عملية

### مثال 1: إرسال رسالة ترحيب عبر WhatsApp
```php
use App\Models\User;

$user = User::find(1);

if ($user->whatsapp_number) {
    $message = "مرحباً {$user->name}! شكراً لتسجيلك في منصتنا.";
    $whatsappLink = $user->whatsapp_url . '?text=' . urlencode($message);

    // يمكن استخدام هذا الرابط في:
    // - إرساله عبر البريد الإلكتروني
    // - عرضه في لوحة التحكم
    // - استخدامه مع n8n للإرسال التلقائي
}
```

### مثال 2: البحث عن مستخدم برقم الهاتف
```php
// البحث بالرقم الكامل
$user = User::where('full_phone', '+966512345678')->first();

// البحث برمز الدولة ورقم الهاتف
$user = User::where('country_code', '+966')
            ->where('phone', '512345678')
            ->first();
```

### مثال 3: عرض زر WhatsApp في قائمة المستخدمين
```blade
<!-- في صفحة عرض المستخدمين -->
<table class="table">
    @foreach($users as $user)
    <tr>
        <td>{{ $user->name }}</td>
        <td>{{ $user->email }}</td>
        <td>
            @if($user->full_phone)
                <span class="badge bg-success">{{ $user->full_phone }}</span>
                <a href="{{ $user->whatsapp_url }}" target="_blank" class="btn btn-sm btn-success ms-2">
                    <i class="fab fa-whatsapp"></i>
                </a>
            @else
                <span class="text-muted">-</span>
            @endif
        </td>
    </tr>
    @endforeach
</table>
```

---

## 🛠️ التخصيص

### تغيير الدولة الافتراضية
في ملف `create.blade.php`:
```javascript
const iti = window.intlTelInput(phoneInput, {
    initialCountry: "eg", // مصر
    // أو
    initialCountry: "ae", // الإمارات
});
```

### إضافة دول مفضلة في القائمة
```javascript
preferredCountries: ["sa", "ae", "eg", "jo", "kw"],
```

### تعطيل التحقق التلقائي
```javascript
// احذف هذا الجزء إذا لم ترد التحقق قبل الإرسال:
if (phoneInput.value && !iti.isValidNumber()) {
    // ...
}
```

---

## 📱 دعم الدول الرئيسية

الدول المضافة افتراضياً في القائمة المفضلة:
- 🇸🇦 السعودية (+966)
- 🇦🇪 الإمارات (+971)
- 🇪🇬 مصر (+20)
- 🇯🇴 الأردن (+962)
- 🇰🇼 الكويت (+965)
- 🇧🇭 البحرين (+973)
- 🇶🇦 قطر (+974)
- 🇴🇲 عمان (+968)

---

## 🔗 التكامل مع n8n

### سيناريو: إرسال رسالة WhatsApp تلقائياً عند تسجيل طالب

1. **في Laravel** - يتم إطلاق Webhook:
```php
event(new N8nWebhookEvent('student.enrolled', [
    'student_name' => $student->name,
    'whatsapp_number' => $student->whatsapp_number,
    'course_name' => $course->name,
]));
```

2. **في n8n** - استقبال الـ Webhook:
   - أضف **Webhook** node
   - أضف **WhatsApp Business** node
   - استخدم `{{$json["whatsapp_number"]}}` كرقم المستلم
   - أرسل الرسالة: "مرحباً {{$json["student_name"]}}! تم تسجيلك في {{$json["course_name"]}}"

---

## ✅ اختبار النظام

### الخطوة 1: أضف مستخدم جديد
```
http://127.0.0.1:8000/admin/users/create
```

### الخطوة 2: املأ البيانات
- **الاسم:** أحمد محمد
- **البريد الإلكتروني:** ahmad@example.com
- **رقم الهاتف:** اختر السعودية (+966) وأدخل `512345678`
- **كلمة المرور:** 12345678

### الخطوة 3: تحقق من التخزين
```bash
php artisan tinker

$user = User::latest()->first();
echo $user->country_code;    // +966
echo $user->phone;           // 512345678
echo $user->full_phone;      // +966512345678
echo $user->whatsapp_number; // 966512345678
echo $user->whatsapp_url;    // https://wa.me/966512345678
```

---

## 🎨 الواجهة

النظام يستخدم:
- ✅ **intl-tel-input v19.5.6** - أحدث إصدار
- ✅ **Bootstrap 5** - للتنسيق
- ✅ **Font Awesome** - للأيقونات
- ✅ **RTL Support** - دعم كامل للعربية

---

## 🔧 استكشاف الأخطاء

### المشكلة: رقم الهاتف لا يُحفظ
**الحل:** تأكد من أن JavaScript يعمل وأن الحقول المخفية تُملأ بالبيانات. افتح Console في المتصفح وتحقق من عدم وجود أخطاء.

### المشكلة: رمز الدولة لا يظهر
**الحل:** تأكد من تحميل CSS و JS من CDN:
```html
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/intl-tel-input@19.5.6/build/css/intlTelInput.css">
<script src="https://cdn.jsdelivr.net/npm/intl-tel-input@19.5.6/build/js/intlTelInput.min.js"></script>
```

### المشكلة: خطأ "Duplicate entry" للهاتف
**الحل:** رقم الهاتف مستخدم مسبقاً. قاعدة البيانات تمنع تكرار `full_phone`.

---

## 📚 المراجع

- [intl-tel-input Documentation](https://github.com/jackocnr/intl-tel-input)
- [WhatsApp API Docs](https://faq.whatsapp.com/general/chats/how-to-use-click-to-chat)
- [Laravel Validation](https://laravel.com/docs/11.x/validation)

---

## 🎉 جاهز للاستخدام!

النظام الآن جاهز بالكامل:
- ✅ إدخال رقم الهاتف مع رمز الدولة
- ✅ التحقق التلقائي من صحة الرقم
- ✅ تخزين ذكي في قاعدة البيانات
- ✅ تكامل WhatsApp جاهز
- ✅ دعم n8n Webhooks

**ابدأ الآن:** http://127.0.0.1:8000/admin/users/create 🚀
