# 🚀 البداية السريعة - نظام الشهادات

## ✅ كل شيء جاهز! ابدأ الآن في 3 خطوات

---

## الخطوة 1️⃣: إنشاء قالب الشهادة الأول

### من لوحة الأدمن:

```
1. اذهب إلى: Sidebar → الشهادات → قوالب الشهادات
2. أو مباشرة: http://localhost/admin/certificate-templates/create
```

### املأ البيانات:

```
الاسم:                شهادة إتمام الكورس
النوع:                HTML
محتوى HTML:           [انسخ من الملف: resources/views/certificates/templates/default.blade.php]
الاتجاه:              Landscape
حجم الصفحة:           A4

المتطلبات:
✓ يتطلب إكمال الكورس
  نسبة الإكمال:       100%

□ يتطلب حضور
□ يتطلب اختبار نهائي

□ لها تاريخ انتهاء

✓ إصدار تلقائي عند الإكمال
✓ تعيين كقالب افتراضي
```

### اضغط "حفظ"

---

## الخطوة 2️⃣: إصدار شهادة تجريبية

### من لوحة الأدمن:

```
1. اذهب إلى: Sidebar → الشهادات → إصدار شهادة
2. أو مباشرة: http://localhost/admin/certificates/create
```

### اختر:

```
الطالب:      [اختر أي طالب]
الكورس:      [اختر أي كورس]
القالب:      شهادة إتمام الكورس (الذي أنشأته للتو)
```

### اضغط "إصدار الشهادة"

✅ **تم! الشهادة صدرت بنجاح**

---

## الخطوة 3️⃣: التحقق من الشهادة

### احصل على كود التحقق:

```
من صفحة تفاصيل الشهادة، انسخ "كود التحقق"
أو امسح QR Code الموجود
```

### اذهب للتحقق العام:

```
http://localhost/verify-certificate
```

### أدخل الكود

✅ **تم! الشهادة تم التحقق منها**

---

## 🎯 الروابط السريعة

### للأدمن (Admin):

| الوظيفة | الرابط |
|---------|--------|
| 📋 قائمة الشهادات | `/admin/certificates` |
| ➕ إصدار شهادة | `/admin/certificates/create` |
| 📄 القوالب | `/admin/certificate-templates` |
| ➕ قالب جديد | `/admin/certificate-templates/create` |

### للطالب (Student):

| الوظيفة | الرابط |
|---------|--------|
| 🎓 شهاداتي | `/student/certificates` |

### عام (Public):

| الوظيفة | الرابط |
|---------|--------|
| 🔍 التحقق | `/verify-certificate` |

---

## 💡 نصائح سريعة

### محتوى HTML للقالب:

يمكنك نسخ المحتوى من:
```
resources/views/certificates/templates/default.blade.php
```

### الحقول الديناميكية:

استخدم هذه الحقول في HTML:

```
{student_name}          - اسم الطالب
{course_name}           - اسم الكورس
{certificate_number}    - رقم الشهادة
{issue_date_ar}         - تاريخ الإصدار بالعربي
{completion_percentage} - نسبة الإكمال
{qr_code}               - QR Code
```

### إصدار جماعي:

من صفحة قائمة الشهادات:
```
1. اضغط "إصدار جماعي"
2. اختر الكورس
3. اختر القالب
4. سيتم إصدار شهادات لكل الطلاب المؤهلين تلقائياً
```

---

## 🎨 تخصيص تصميم الشهادة

### تعديل قالب PDF:

```
ملف: resources/views/certificates/templates/default.blade.php

- غير الألوان
- غير الخطوط
- أضف شعارك
- عدل التصميم كما تريد
```

### استخدام صورة (Photoshop):

```
1. صمم شهادتك في Photoshop
2. احفظها كـ PNG/JPG
3. في القالب اختر النوع: Image
4. ارفع الصورة
5. حدد مواقع النصوص (X, Y coordinates)
```

---

## 📊 مراقبة الشهادات

### من لوحة الأدمن:

```
/admin/certificates

ستجد:
✅ إحصائيات شاملة
✅ فلترة حسب (الحالة، الكورس)
✅ بحث بـ (رقم الشهادة، اسم الطالب، الكورس)
✅ تحميل PDF
✅ إلغاء الشهادات
✅ إعادة الإصدار
```

---

## 🔧 إعدادات متقدمة

### ملف الإعدادات:

```
config/certificate.php
```

### أمثلة:

```php
// تغيير بادئة الرقم
'certificate_prefix' => 'CERT'  // → CERT-2025-00001

// تعطيل QR Code
'qr_code' => ['enabled' => false]

// تفعيل انتهاء الصلاحية
'expiry' => [
    'enabled' => true,
    'default_months' => 12
]
```

---

## ⚡ الأسئلة الشائعة

### س: كيف أغير تصميم الشهادة؟

```
ج: عدل الملف:
   resources/views/certificates/templates/default.blade.php
```

### س: كيف أضيف حقل جديد؟

```
ج: في CertificateService.php، أضف الحقل في:
   - replaceDynamicFields()
   - getFieldValue()
```

### س: كيف أصدر شهادات لكل الطلاب دفعة واحدة؟

```
ج: استخدم زر "إصدار جماعي" في صفحة الشهادات
```

### س: كيف أطبع الشهادة؟

```
ج: حمّل PDF ثم اطبع من أي برنامج PDF
```

---

## 🎉 استمتع!

**البطيخ شغال! كلشي جاهز!** 🍉✨

النظام جاهز 100% للإنتاج والاستخدام الفوري.

---

**للدعم:** راجع ملف `CERTIFICATE_SYSTEM_READY.md` للتفاصيل الكاملة
