# Quiz System Routes Reference

## Admin Routes (Prefix: `/admin`)

### Quizzes Management
| Method | URI | Name | Description |
|--------|-----|------|-------------|
| GET | `/admin/quizzes` | `quizzes.index` | List all quizzes |
| GET | `/admin/quizzes/create` | `quizzes.create` | Show create quiz form |
| POST | `/admin/quizzes` | `quizzes.store` | Store new quiz |
| GET | `/admin/quizzes/{id}` | `quizzes.show` | Show quiz details |
| GET | `/admin/quizzes/{id}/edit` | `quizzes.edit` | Show edit quiz form |
| PUT/PATCH | `/admin/quizzes/{id}` | `quizzes.update` | Update quiz |
| DELETE | `/admin/quizzes/{id}` | `quizzes.destroy` | Delete quiz |
| POST | `/admin/quizzes/{id}/toggle-publish` | `quizzes.toggle-publish` | Toggle publish status |
| GET | `/admin/quizzes/course/{courseId}/lessons` | `quizzes.get-lessons` | Get lessons by course (AJAX) |
| POST | `/admin/quizzes/{id}/recalculate-score` | `quizzes.recalculate-score` | Recalculate max score |

### Question Bank Management
| Method | URI | Name | Description |
|--------|-----|------|-------------|
| GET | `/admin/question-bank` | `question-bank.index` | List all questions |
| GET | `/admin/question-bank/create` | `question-bank.create` | Show create question form |
| POST | `/admin/question-bank` | `question-bank.store` | Store new question |
| GET | `/admin/question-bank/{id}` | `question-bank.show` | Show question details |
| GET | `/admin/question-bank/{id}/edit` | `question-bank.edit` | Show edit question form |
| PUT/PATCH | `/admin/question-bank/{id}` | `question-bank.update` | Update question |
| DELETE | `/admin/question-bank/{id}` | `question-bank.destroy` | Delete question |
| POST | `/admin/question-bank/{id}/duplicate` | `question-bank.duplicate` | Duplicate question |
| GET | `/admin/question-bank/{id}/preview` | `question-bank.preview` | Preview question (AJAX) |
| GET | `/admin/question-bank/course/{courseId}/questions` | `question-bank.by-course` | Get questions by course (AJAX) |
| GET | `/admin/question-bank/type/{typeId}/questions` | `question-bank.by-type` | Get questions by type (AJAX) |
| POST | `/admin/question-bank/bulk-action` | `question-bank.bulk-action` | Bulk actions on questions |

### Question Pools Management
| Method | URI | Name | Description |
|--------|-----|------|-------------|
| GET | `/admin/question-pools` | `question-pools.index` | List all pools |
| GET | `/admin/question-pools/create` | `question-pools.create` | Show create pool form |
| POST | `/admin/question-pools` | `question-pools.store` | Store new pool |
| GET | `/admin/question-pools/{id}` | `question-pools.show` | Show pool details |
| GET | `/admin/question-pools/{id}/edit` | `question-pools.edit` | Show edit pool form |
| PUT/PATCH | `/admin/question-pools/{id}` | `question-pools.update` | Update pool |
| DELETE | `/admin/question-pools/{id}` | `question-pools.destroy` | Delete pool |
| POST | `/admin/question-pools/{id}/duplicate` | `question-pools.duplicate` | Duplicate pool |
| POST | `/admin/question-pools/{id}/add-question` | `question-pools.add-question` | Add question to pool |
| DELETE | `/admin/question-pools/{id}/remove-question/{itemId}` | `question-pools.remove-question` | Remove question from pool |
| POST | `/admin/question-pools/{id}/update-order` | `question-pools.update-order` | Update questions order |
| POST | `/admin/question-pools/{id}/generate-questions` | `question-pools.generate-questions` | Generate random questions |
| GET | `/admin/question-pools/{id}/statistics` | `question-pools.statistics` | Get pool statistics (AJAX) |

### Quiz Grading
| Method | URI | Name | Description |
|--------|-----|------|-------------|
| GET | `/admin/grading` | `grading.index` | Grading dashboard |
| GET | `/admin/grading/{attemptId}` | `grading.show` | Show grading interface |
| POST | `/admin/grading/responses/{responseId}/grade` | `grading.grade-response` | Grade single response |
| POST | `/admin/grading/bulk-grade` | `grading.bulk-grade` | Grade multiple responses |
| POST | `/admin/grading/{attemptId}/complete` | `grading.complete` | Complete grading |
| POST | `/admin/grading/{attemptId}/regrade` | `grading.regrade` | Regrade attempt |
| GET | `/admin/grading/quiz/{quizId}/stats` | `grading.quiz-stats` | Get quiz statistics (AJAX) |
| POST | `/admin/grading/export-report` | `grading.export-report` | Export grading report |

### Quiz Analytics
| Method | URI | Name | Description |
|--------|-----|------|-------------|
| GET | `/admin/quiz-analytics` | `quiz-analytics.index` | Analytics dashboard |
| GET | `/admin/quiz-analytics/quiz/{quizId}` | `quiz-analytics.quiz` | Quiz analytics |
| GET | `/admin/quiz-analytics/student/{studentId}` | `quiz-analytics.student` | Student analytics |
| GET | `/admin/quiz-analytics/course/{courseId}` | `quiz-analytics.course` | Course analytics |
| POST | `/admin/quiz-analytics/compare` | `quiz-analytics.compare` | Compare quizzes |
| POST | `/admin/quiz-analytics/export` | `quiz-analytics.export` | Export analytics |

---

## Student Routes (Prefix: `/student`)

### Browse & Take Quizzes
| Method | URI | Name | Description |
|--------|-----|------|-------------|
| GET | `/student/quizzes` | `student.quizzes.index` | Browse available quizzes |
| GET | `/student/quizzes/{id}` | `student.quizzes.show` | View quiz details |
| POST | `/student/quizzes/{id}/start` | `student.quizzes.start` | Start new attempt |
| GET | `/student/quizzes/attempt/{attemptId}/take` | `student.quizzes.take` | Take quiz interface |
| POST | `/student/quizzes/attempt/{attemptId}/save-answer` | `student.quizzes.save-answer` | Save answer (AJAX) |
| POST | `/student/quizzes/attempt/{attemptId}/mark-review/{questionId}` | `student.quizzes.mark-review` | Mark for review |
| POST | `/student/quizzes/attempt/{attemptId}/submit` | `student.quizzes.submit` | Submit quiz |
| POST | `/student/quizzes/attempt/{attemptId}/mark-completed` | `student.quizzes.mark-completed` | Mark as completed ✅ "تم الإنجاز" |
| GET | `/student/quizzes/attempt/{attemptId}/progress` | `student.quizzes.progress` | Get progress (AJAX) |

### Review & Analytics
| Method | URI | Name | Description |
|--------|-----|------|-------------|
| GET | `/student/quizzes/review` | `student.quizzes.review.index` | List all attempts |
| GET | `/student/quizzes/review/{attemptId}` | `student.quizzes.review.show` | Review specific attempt |
| GET | `/student/quizzes/review/analytics/overview` | `student.quizzes.review.analytics` | Performance analytics |
| GET | `/student/quizzes/review/quiz/{quizId}/compare` | `student.quizzes.review.compare` | Compare attempts |
| GET | `/student/quizzes/review/quiz/{quizId}/history` | `student.quizzes.review.history` | Quiz history |
| GET | `/student/quizzes/review/{attemptId}/question/{questionId}` | `student.quizzes.review.question` | Question review (AJAX) |
| GET | `/student/quizzes/review/{attemptId}/download-report` | `student.quizzes.review.download-report` | Download report |

---

## Usage Examples

### Admin - Creating a Quiz
```blade
<a href="{{ route('quizzes.create') }}">Create New Quiz</a>
<form action="{{ route('quizzes.store') }}" method="POST">
    @csrf
    <!-- Form fields -->
</form>
```

### Admin - Toggle Publish
```blade
<form action="{{ route('quizzes.toggle-publish', $quiz->id) }}" method="POST">
    @csrf
    <button type="submit">{{ $quiz->is_published ? 'Unpublish' : 'Publish' }}</button>
</form>
```

### Student - Browse Quizzes
```blade
<a href="{{ route('student.quizzes.index') }}">Browse Quizzes</a>
```

### Student - Start Quiz
```blade
<form action="{{ route('student.quizzes.start', $quiz->id) }}" method="POST">
    @csrf
    <button type="submit">Start Quiz</button>
</form>
```

### Student - Take Quiz
```blade
<form action="{{ route('student.quizzes.save-answer', $attempt->id) }}" method="POST" id="answer-form">
    @csrf
    <!-- Answer fields -->
</form>
```

### Student - Submit Quiz
```blade
<form action="{{ route('student.quizzes.submit', $attempt->id) }}" method="POST">
    @csrf
    <button type="submit">Submit Quiz</button>
</form>
```

### Student - Mark as Completed (تم الإنجاز)
```blade
<form action="{{ route('student.quizzes.mark-completed', $attempt->id) }}" method="POST">
    @csrf
    <button type="submit">تم الإنجاز ✅</button>
</form>
```

### Student - Review Attempt
```blade
<a href="{{ route('student.quizzes.review.show', $attempt->id) }}">Review Attempt</a>
```

---

## Route Name Patterns

### Admin Routes
- **Quizzes**: `quizzes.{action}`
- **Question Bank**: `question-bank.{action}`
- **Question Pools**: `question-pools.{action}`
- **Grading**: `grading.{action}`
- **Analytics**: `quiz-analytics.{action}`

### Student Routes
- **Browse/Take**: `student.quizzes.{action}`
- **Review**: `student.quizzes.review.{action}`

---

## Important Notes

1. **Naming Consistency**: All route names follow kebab-case for URLs and dot notation for names
2. **Middleware**: Admin routes use `auth` + `role:admin`, Student routes use `auth` + `role:student`
3. **AJAX Routes**: Routes marked with (AJAX) return JSON responses
4. **Resource Routes**: Standard CRUD routes use Laravel's resource controller pattern
5. **تم الإنجاز Button**: Special route `student.quizzes.mark-completed` for marking quiz as completed

---

Generated: {{ date('Y-m-d H:i:s') }}
