# 📁 نظام جدول أعمال الطلاب - Student Works System

## ✅ تم إنشاؤه بنجاح - 2025-11-27

---

## 📋 نظرة عامة

نظام كامل ومتقدم لإدارة وعرض أعمال الطلاب (Portfolio/Student Works) يسمح للطلاب بإضافة أعمالهم ومشاريعهم، وللأدمن بمراجعتها واعتمادها.

---

## 🗂️ الملفات التي تم إنشاؤها/تعديلها

### 1. Database Migration
📄 **الملف**: `database/migrations/2025_11_27_183451_add_advanced_fields_to_student_works_table.php`

**الحقول الجديدة المضافة**:
- `course_id` - ربط العمل بدورة معينة
- `category` - تصنيف العمل (project, assignment, creative, research, other)
- `tags` - تاجات للبحث (JSON)
- `attachments` - ملفات مرفقة (JSON)
- `gallery` - معرض صور (JSON)
- `github_url` - رابط GitHub
- `demo_url` - رابط التجربة الحية
- `technologies` - التقنيات المستخدمة
- `completion_date` - تاريخ الإنجاز
- `views_count` - عدد المشاهدات
- `likes_count` - عدد الإعجابات
- `rating` - تقييم من المدرس (0-10)
- `admin_feedback` - ملاحظات المدرس
- `status` - حالة العمل (draft, pending, approved, rejected)
- `approved_by` - من اعتمد العمل
- `approved_at` - تاريخ الاعتماد

---

### 2. Model
📄 **الملف**: `app/Models/StudentWork.php`

**العلاقات (Relationships)**:
```php
- student() → User (الطالب صاحب العمل)
- course() → Course (الدورة المرتبطة)
- approver() → User (من اعتمد العمل)
```

**Scopes المتاحة**:
```php
- active() - الأعمال النشطة
- featured() - الأعمال المميزة
- approved() - الأعمال المعتمدة
- pending() - الأعمال قيد المراجعة
- draft() - المسودات
- ordered() - ترتيب حسب الأولوية
- byStudent($studentId) - أعمال طالب معين
- byCategory($category) - أعمال حسب التصنيف
- search($term) - بحث في العناوين والوصف
```

**دوال مساعدة**:
```php
- getCategories() - قائمة التصنيفات المتاحة
- getStatuses() - قائمة الحالات المتاحة
- incrementViews() - زيادة عدد المشاهدات
- isApproved() - هل معتمد؟
- isPending() - هل قيد المراجعة؟
- getImageUrlAttribute - رابط الصورة الرئيسية
```

---

### 3. Controllers

#### أ) Admin Controller
📄 **الملف**: `app/Http/Controllers/Admin/StudentWorkController.php`

**الدوال المتاحة**:
1. `index()` - عرض جميع الأعمال مع فلترة وبحث
2. `create()` - نموذج إضافة عمل جديد
3. `store()` - حفظ عمل جديد
4. `show($work)` - عرض تفاصيل عمل
5. `edit($work)` - نموذج تعديل عمل
6. `update($work)` - تحديث عمل
7. `destroy($work)` - حذف عمل
8. `approve($work)` - اعتماد عمل ✅
9. `reject($work)` - رفض عمل ❌
10. `toggleFeatured($work)` - إبراز/إلغاء إبراز عمل ⭐
11. `toggleActive($work)` - تفعيل/إلغاء تفعيل عمل 🔄

**الإحصائيات المتاحة**:
- إجمالي الأعمال
- الأعمال قيد المراجعة
- الأعمال المعتمدة
- الأعمال المرفوضة

#### ب) Student Controller
📄 **الملف**: `app/Http/Controllers/Student/StudentWorkController.php`

**الدوال المتاحة**:
1. `index()` - عرض أعمال الطالب الشخصية
2. `create()` - نموذج إضافة عمل جديد
3. `store()` - حفظ عمل جديد
4. `show($work)` - عرض تفاصيل عمل (مع التحقق من الصلاحيات)
5. `edit($work)` - نموذج تعديل عمل
6. `update($work)` - تحديث عمل
7. `destroy($work)` - حذف عمل (المسودات فقط)
8. `submit($work)` - تقديم عمل للمراجعة 📤
9. `portfolio()` - عرض البورتفوليو العام 🎨

**الإحصائيات المتاحة**:
- إجمالي أعمالي
- المسودات
- قيد المراجعة
- المعتمدة

---

### 4. Routes

#### أ) Admin Routes
📄 **الملف**: `routes/admin.php`

```php
Route::prefix('student-works')->name('admin.student-works.')->group(function () {
    Route::get('/', [StudentWorkController::class, 'index'])->name('index');
    Route::get('/create', [StudentWorkController::class, 'create'])->name('create');
    Route::post('/', [StudentWorkController::class, 'store'])->name('store');
    Route::get('/{studentWork}', [StudentWorkController::class, 'show'])->name('show');
    Route::get('/{studentWork}/edit', [StudentWorkController::class, 'edit'])->name('edit');
    Route::put('/{studentWork}', [StudentWorkController::class, 'update'])->name('update');
    Route::delete('/{studentWork}', [StudentWorkController::class, 'destroy'])->name('destroy');
    Route::post('/{studentWork}/approve', [StudentWorkController::class, 'approve'])->name('approve');
    Route::post('/{studentWork}/reject', [StudentWorkController::class, 'reject'])->name('reject');
    Route::post('/{studentWork}/toggle-featured', [StudentWorkController::class, 'toggleFeatured'])->name('toggle-featured');
    Route::post('/{studentWork}/toggle-active', [StudentWorkController::class, 'toggleActive'])->name('toggle-active');
});
```

#### ب) Student Routes
📄 **الملف**: `routes/student.php`

```php
Route::prefix('works')->name('student.works.')->group(function () {
    Route::get('/', [StudentWorkController::class, 'index'])->name('index');
    Route::get('/create', [StudentWorkController::class, 'create'])->name('create');
    Route::post('/', [StudentWorkController::class, 'store'])->name('store');
    Route::get('/portfolio', [StudentWorkController::class, 'portfolio'])->name('portfolio');
    Route::get('/{work}', [StudentWorkController::class, 'show'])->name('show');
    Route::get('/{work}/edit', [StudentWorkController::class, 'edit'])->name('edit');
    Route::put('/{work}', [StudentWorkController::class, 'update'])->name('update');
    Route::delete('/{work}', [StudentWorkController::class, 'destroy'])->name('destroy');
    Route::post('/{work}/submit', [StudentWorkController::class, 'submit'])->name('submit');
});
```

---

### 5. Policy (الصلاحيات)
📄 **الملف**: `app/Policies/StudentWorkPolicy.php`

**القواعد**:
- ✅ Admin يمكنه الوصول لكل شيء
- ✅ Student يمكنه فقط عرض/تعديل أعماله الخاصة
- ✅ Student يمكنه فقط حذف المسودات
- ✅ Admin فقط يمكنه اعتماد/رفض الأعمال

---

### 6. Navigation (القوائم الجانبية)

#### أ) Admin Sidebar
📄 **الملف**: `resources/views/admin/layouts/main-sidebar.blade.php`

```html
<li class="slide {{ request()->routeIs('admin.student-works.*') ? 'active' : '' }}">
    <a href="{{ route('admin.student-works.index') }}" class="side-menu__item">
        <i class="ri-folder-user-line side-menu__icon"></i>
        <span class="side-menu__label">جدول أعمال الطلاب</span>
    </a>
</li>
```

#### ب) Student Sidebar
📄 **الملف**: `resources/views/student/layouts/main-sidebar.blade.php`

```html
<li class="slide {{ request()->routeIs('student.works.*') ? 'active' : '' }}">
    <a href="{{ route('student.works.index') }}" class="side-menu__item">
        <i class="ri-folder-user-line side-menu__icon"></i>
        <span class="side-menu__label">جدول أعمالي</span>
    </a>
</li>
```

---

## 🎨 التصنيفات المتاحة

| التصنيف | الاسم | الأيقونة | اللون |
|---------|------|----------|-------|
| project | مشروع | ri-code-box-line | primary |
| assignment | واجب | ri-file-text-line | success |
| creative | عمل إبداعي | ri-palette-line | warning |
| research | بحث | ri-search-line | info |
| other | أخرى | ri-folder-line | secondary |

---

## 📊 الحالات المتاحة

| الحالة | الاسم | اللون | الأيقونة |
|--------|------|-------|---------|
| draft | مسودة | secondary | ri-draft-line |
| pending | قيد المراجعة | warning | ri-time-line |
| approved | معتمد | success | ri-checkbox-circle-line |
| rejected | مرفوض | danger | ri-close-circle-line |

---

## 🔄 سير العمل (Workflow)

```
1. الطالب ينشئ عمل جديد → status: draft
2. الطالب يقدم العمل للمراجعة → status: pending
3. الأدمن يراجع العمل:
   - يعتمد → status: approved ✅
   - يرفض (مع ملاحظات) → status: rejected ❌
4. إذا اعتمد، يظهر في البورتفوليو العام
5. الأدمن يمكنه إبراز الأعمال المميزة ⭐
```

---

## 🎯 الميزات الرئيسية

### ✅ للطلاب:
1. ✏️ إضافة أعمالهم ومشاريعهم
2. 📁 تصنيف الأعمال حسب النوع
3. 🏷️ إضافة تاجات للبحث
4. 🖼️ رفع صورة رئيسية ومعرض صور
5. 📎 إرفاق ملفات (PDF, Word, etc)
6. 🔗 إضافة روابط (GitHub, Demo, Website)
7. 💻 تحديد التقنيات المستخدمة
8. 📅 تحديد تاريخ الإنجاز
9. 📤 تقديم للمراجعة
10. 🎨 عرض البورتفوليو الشخصي

### ✅ للأدمن:
1. 👀 عرض جميع أعمال الطلاب
2. 🔍 بحث وفلترة متقدمة
3. ✅ اعتماد الأعمال
4. ❌ رفض الأعمال مع ملاحظات
5. ⭐ إبراز الأعمال المميزة
6. ⭐ تقييم الأعمال (0-10)
7. 💬 إضافة ملاحظات وفيدباك
8. 📊 إحصائيات شاملة
9. 🆕 إضافة أعمال للطلاب
10. ✏️ تعديل أي عمل

---

## 📦 الخطوات التالية (ما تبقى)

### المرحلة 1: إنشاء الواجهات (Views)
```
✅ يجب إنشاء:
1. resources/views/admin/student-works/index.blade.php
2. resources/views/admin/student-works/create.blade.php
3. resources/views/admin/student-works/edit.blade.php
4. resources/views/admin/student-works/show.blade.php
5. resources/views/student/works/index.blade.php
6. resources/views/student/works/create.blade.php
7. resources/views/student/works/edit.blade.php
8. resources/views/student/works/show.blade.php
9. resources/views/student/works/portfolio.blade.php
```

### المرحلة 2: تحسينات اختيارية
- إضافة نظام التعليقات على الأعمال
- إضافة نظام الإعجاب (Likes)
- إضافة مشاركة على السوشيال ميديا
- تصدير البورتفوليو كـ PDF
- عرض عام للأعمال المميزة

---

## 🚀 كيفية الاستخدام

### للطلاب:
1. اذهب إلى **جدول أعمالي** من القائمة الجانبية
2. اضغط **إضافة عمل جديد**
3. املأ البيانات (العنوان، الوصف، الصورة، إلخ)
4. احفظ كـ **مسودة** أو **قدم للمراجعة**
5. انتظر موافقة الأدمن

### للأدمن:
1. اذهب إلى **جدول أعمال الطلاب** من القائمة الجانبية
2. راجع الأعمال قيد المراجعة
3. اعتمد أو ارفض مع الملاحظات
4. يمكنك إبراز الأعمال المميزة
5. أضف تقييم للأعمال

---

## 🔗 الروابط المهمة

### Admin:
- القائمة: `/admin/student-works`
- إضافة: `/admin/student-works/create`
- عرض: `/admin/student-works/{id}`
- تعديل: `/admin/student-works/{id}/edit`

### Student:
- أعمالي: `/student/works`
- إضافة: `/student/works/create`
- بورتفوليو: `/student/works/portfolio`
- عرض: `/student/works/{id}`
- تعديل: `/student/works/{id}/edit`

---

## 📝 ملاحظات مهمة

1. ✅ تم تطبيق جميع الـ Migrations بنجاح
2. ✅ جميع الـ Routes مسجلة ومفعلة
3. ✅ الصلاحيات (Policies) جاهزة
4. ✅ القوائم الجانبية محدثة
5. ⚠️ **يتبقى فقط**: إنشاء الواجهات (Views)

---

## 💡 نصائح للمطورين

1. استخدم `StudentWork::getCategories()` للحصول على قائمة التصنيفات
2. استخدم `StudentWork::getStatuses()` للحصول على قائمة الحالات
3. الصور تُحفظ في `storage/student-works/images/`
4. استخدم `$work->incrementViews()` لزيادة المشاهدات
5. تحقق من الصلاحيات باستخدام `@can('update', $work)`

---

## ✨ تم الإنجاز بنجاح!

**الحمد لله** تم بناء نظام كامل ومتكامل لجدول أعمال الطلاب! 🎉

**المطور**: Claude Code
**التاريخ**: 2025-11-27
**الحالة**: جاهز للاستخدام (بعد إنشاء الواجهات)
