# 🚀 دليل تجربة نظام n8n Integration

## 🎯 الهدف
تجربة نظام التكامل الثنائي بين Laravel LMS و n8n

---

## ✅ المتطلبات الأساسية

### 1. تفعيل Queue Worker
```bash
# في Terminal منفصل، قم بتشغيل:
php artisan queue:work --queue=webhooks --tries=3
```
**مهم:** اترك هذا الـ Terminal مفتوحاً طوال فترة التجربة!

### 2. التأكد من إعدادات .env
تحقق من أن الإعدادات التالية موجودة في `.env`:
```env
N8N_WEBHOOK_SECRET=your-secret-key-here-change-in-production
N8N_DEFAULT_TIMEOUT=30
N8N_DEFAULT_RETRY_ATTEMPTS=3
N8N_VERIFY_SSL=false
N8N_QUEUE_NAME=webhooks
QUEUE_CONNECTION=database
```

---

## 📋 خطوات التجربة

### السيناريو 1️⃣: تجربة Outgoing Webhooks (Laravel → n8n)

#### الخطوة 1: افتح لوحة التحكم
```
http://127.0.0.1:8000/admin/n8n
```

#### الخطوة 2: أنشئ نقطة نهاية تجريبية
1. اذهب إلى **نقاط النهاية** → **إضافة نقطة نهاية جديدة**
2. املأ البيانات:
   - **الاسم:** Test Webhook
   - **نوع الحدث:** `student.enrolled`
   - **URL:** `https://webhook.site/unique-id` (احصل على URL من https://webhook.site)
   - **Secret Key:** اضغط "توليد"
   - **عدد محاولات الإعادة:** 3
   - **المهلة:** 30
3. فعّل نقطة النهاية ✅
4. احفظ

#### الخطوة 3: اختبر نقطة النهاية
```bash
# في Terminal:
php artisan tinker

# قم بتشغيل:
event(new \App\Events\N8nWebhookEvent('student.enrolled', [
    'student_id' => 123,
    'course_id' => 456,
    'student_name' => 'أحمد محمد',
    'course_name' => 'Laravel للمبتدئين',
    'enrolled_at' => now()->toDateTimeString()
]));
```

#### الخطوة 4: راقب النتائج
1. اذهب إلى **السجلات**
2. يجب أن ترى سجل جديد بحالة "Sent" أو "Pending"
3. افتح webhook.site وشاهد البيانات المستلمة!

---

### السيناريو 2️⃣: تجربة Incoming Webhooks (n8n → Laravel)

#### الخطوة 1: تحقق من المعالجات المتاحة
```
http://127.0.0.1:8000/admin/n8n/handlers
```
يجب أن ترى 8 معالجات مختلفة مثل:
- `user.create`
- `user.update`
- `course.enroll`
- `notification.send`
- وغيرها...

#### الخطوة 2: اختبر معالج إنشاء مستخدم
استخدم **Postman** أو **curl**:

```bash
curl -X POST http://127.0.0.1:8000/api/webhooks/n8n/incoming \
  -H "Content-Type: application/json" \
  -H "X-N8N-Signature: your-secret-key-here-change-in-production" \
  -d '{
    "handler_type": "user.create",
    "data": {
        "name": "محمد أحمد",
        "email": "test-n8n@example.com",
        "password": "SecurePass123!",
        "role": "student"
    }
}'
```

#### الخطوة 3: تحقق من النتيجة
```bash
# في Terminal:
php artisan tinker

# تحقق من المستخدم الجديد:
\App\Models\User::where('email', 'test-n8n@example.com')->first();
```

---

### السيناريو 3️⃣: تجربة Webhook Retry (إعادة المحاولة)

#### الخطوة 1: أنشئ endpoint بـ URL خاطئ
- **URL:** `https://invalid-url-that-will-fail.com/webhook`
- باقي البيانات كما في السيناريو 1

#### الخطوة 2: أطلق حدث
```bash
php artisan tinker

event(new \App\Events\N8nWebhookEvent('user.registered', [
    'user_id' => 999,
    'user_name' => 'اختبار فشل',
    'email' => 'test@fail.com'
]));
```

#### الخطوة 3: راقب السجلات
1. اذهب إلى **السجلات**
2. سترى محاولات متعددة (Retrying)
3. في النهاية ستصبح الحالة "Failed"
4. يمكنك الضغط على زر "إعادة المحاولة" يدوياً

---

## 🧪 اختبارات متقدمة

### اختبار 1: إرسال إشعار
```bash
curl -X POST http://127.0.0.1:8000/api/webhooks/n8n/incoming \
  -H "Content-Type: application/json" \
  -H "X-N8N-Signature: your-secret-key-here-change-in-production" \
  -d '{
    "handler_type": "notification.send",
    "data": {
        "user_id": 1,
        "title": "تنبيه من n8n",
        "message": "هذا اختبار لإرسال إشعار من n8n",
        "type": "info"
    }
}'
```

### اختبار 2: تسجيل طالب في كورس
```bash
curl -X POST http://127.0.0.1:8000/api/webhooks/n8n/incoming \
  -H "Content-Type: application/json" \
  -H "X-N8N-Signature: your-secret-key-here-change-in-production" \
  -d '{
    "handler_type": "course.enroll",
    "data": {
        "student_id": 1,
        "course_id": 1
    }
}'
```

---

## 📊 مراقبة الإحصائيات

### عرض الإحصائيات الكاملة
```
http://127.0.0.1:8000/admin/n8n/statistics
```

ستجد:
- إجمالي نقاط النهاية
- إجمالي السجلات
- عدد الطلبات الناجحة
- عدد الطلبات الفاشلة
- معدلات النجاح لكل endpoint

---

## 🔍 استكشاف الأخطاء

### المشكلة: السجلات تظل "Pending"
**الحل:**
```bash
# تأكد من تشغيل Queue Worker:
php artisan queue:work --queue=webhooks
```

### المشكلة: "Unauthorized" عند Incoming Webhook
**الحل:** تأكد من أن الـ Secret Key في الـ Header يطابق قيمة `N8N_WEBHOOK_SECRET` في `.env`

### المشكلة: Endpoint يفشل دائماً
**الحل:**
1. تحقق من صحة الـ URL
2. تحقق من أن الـ SSL Verification معطلة في البيئة المحلية (`N8N_VERIFY_SSL=false`)
3. راجع تفاصيل الخطأ في صفحة السجل

---

## 🎓 أمثلة عملية مع n8n الحقيقي

### إعداد n8n (إذا كان لديك)

1. **قم بتثبيت n8n:**
```bash
npm install n8n -g
n8n start
```

2. **أنشئ Workflow جديد:**
   - أضف **Webhook** node (لاستقبال من Laravel)
   - أضف **HTTP Request** node (لإرسال إلى Laravel)

3. **اختبر Outgoing (Laravel → n8n):**
   - انسخ Webhook URL من n8n
   - استخدمه في نقطة النهاية في Laravel
   - أطلق حدث من Laravel

4. **اختبر Incoming (n8n → Laravel):**
   - أضف HTTP Request node في n8n
   - Method: POST
   - URL: `http://127.0.0.1:8000/api/webhooks/n8n/incoming`
   - Headers: `X-N8N-Signature: your-secret-key`
   - Body: JSON مع `handler_type` و `data`

---

## ✅ Checklist للتجربة الناجحة

- [ ] Queue Worker يعمل
- [ ] إعدادات .env صحيحة
- [ ] أنشأت endpoint واحد على الأقل
- [ ] اختبرت Outgoing webhook بنجاح
- [ ] اختبرت Incoming webhook بنجاح
- [ ] راجعت السجلات
- [ ] شاهدت الإحصائيات
- [ ] قرأت صفحة التوثيق

---

## 📚 مراجع إضافية

### روابط مفيدة:
- صفحة التوثيق الداخلية: http://127.0.0.1:8000/admin/n8n/documentation
- webhook.site للاختبار: https://webhook.site
- n8n Documentation: https://docs.n8n.io

### API Endpoints:
- **Incoming Webhook:** `POST /api/webhooks/n8n/incoming`
- **Get Handlers List:** `GET /api/webhooks/n8n/handlers`
- **Get Handler Docs:** `GET /api/webhooks/n8n/handlers/{handler_type}`

---

## 🎉 نصائح نهائية

1. **ابدأ بسيط:** جرب endpoint واحد أولاً قبل إنشاء endpoints متعددة
2. **استخدم webhook.site:** أسهل طريقة لمشاهدة البيانات المُرسلة
3. **راقب السجلات:** دائماً تحقق من السجلات لفهم ما يحدث
4. **اقرأ التوثيق:** صفحة التوثيق الداخلية تحتوي على أمثلة مفيدة
5. **Queue مهم:** لا تنسى تشغيل Queue Worker!

---

**بالتوفيق! 🚀**

إذا واجهت أي مشكلة، راجع قسم "استكشاف الأخطاء" أو تحقق من Laravel logs:
```bash
tail -f storage/logs/laravel.log
```
