# 🧪 دليل اختبار نظام الإشعارات

## ✅ اختبار سريع (5 دقائق)

### **الخطوة 1: التحقق من صفحة الإشعارات**
```
1. سجل دخول كطالب
2. اذهب إلى: /student/gamification/notifications
3. تحقق من وجود:
   ✅ قائمة الإشعارات
   ✅ فلاتر (الكل / غير المقروءة)
   ✅ قائمة الأنواع (يجب أن يكون "الشهادات" الخيار الأول)
   ✅ زر "تحديد الكل كمقروء"
   ✅ Pagination
```

### **الخطوة 2: التحقق من Header Badge**
```
1. في أي صفحة للطالب
2. انظر لأعلى اليسار
3. تحقق من:
   ✅ أيقونة الجرس موجودة
   ✅ Badge يعرض عدد الإشعارات (إذا كان هناك إشعارات)
   ✅ انقر على الجرس → يظهر Dropdown
   ✅ Dropdown يعرض آخر 10 إشعارات
   ✅ زر "عرض جميع الإشعارات" في الأسفل
```

### **الخطوة 3: التحقق من Sidebar**
```
1. في القائمة الجانبية
2. تحقق من:
   ✅ رابط "الإشعارات" موجود
   ✅ Badge يعرض عدد الإشعارات غير المقروءة
   ✅ انقر على الرابط → يذهب لصفحة الإشعارات
```

---

## 🎓 اختبار إشعارات الشهادات (الميزة الجديدة)

### **الطريقة 1: عبر لوحة الأدمن**
```
1. سجل دخول كأدمن
2. اذهب إلى: /admin/certificates
3. اضغط "إصدار شهادة جديدة"
4. اختر:
   - الطالب
   - الكورس
   - القالب
5. اضغط "إصدار الشهادة"

النتيجة المتوقعة:
✅ رسالة نجاح
✅ سجل دخول كالطالب → يجب أن ترى إشعار جديد في Header Badge
✅ افتح الإشعارات → يجب أن ترى "🎓 تم إصدار شهادتك!"
✅ افتح البريد الإلكتروني → يجب أن يكون هناك إيميل
```

### **الطريقة 2: عبر Tinker (للمطورين)**
```bash
php artisan tinker

# أدخل الكود التالي:
$user = User::find(1); // غير الرقم لمعرف الطالب
$course = Course::find(1); // غير الرقم لمعرف الكورس
$template = CertificateTemplate::first();
$enrollment = $user->enrollments()->where('course_id', $course->id)->first();

$service = app(\App\Services\CertificateService::class);
$certificate = $service->issueCertificate($user, $course, $template, $enrollment);

# للتحقق من الإشعار
$user->gamificationNotifications()->latest()->first();

# النتيجة المتوقعة:
✅ يظهر إشعار بعنوان "🎓 تم إصدار شهادتك!"
✅ النوع: certificate_issued
✅ الأيقونة: fas fa-certificate text-success
```

---

## 🔍 اختبار الفلاتر

### **فلتر الشهادات:**
```
1. اذهب إلى: /student/gamification/notifications
2. من قائمة "جميع الأنواع"
3. اختر "الشهادات"

النتيجة المتوقعة:
✅ تظهر إشعارات الشهادات فقط
✅ URL يتغير إلى: ?type=certificate_issued
```

### **فلتر غير المقروءة:**
```
1. في صفحة الإشعارات
2. اضغط على "غير المقروءة"

النتيجة المتوقعة:
✅ تظهر الإشعارات الجديدة فقط
✅ الإشعارات المقروءة تختفي
✅ URL يتغير إلى: ?filter=unread
```

---

## 🎯 اختبار الإجراءات

### **تحديد كمقروء:**
```
1. في صفحة الإشعارات
2. انقر على إشعار غير مقروء

النتيجة المتوقعة:
✅ يذهب للصفحة المرتبطة (مثلاً صفحة الشهادة)
✅ عند العودة: الإشعار لم يعد "جديد"
✅ Badge "جديد" اختفى
✅ اللون تغير من أزرق إلى عادي
```

### **تحديد الكل كمقروء:**
```
1. في صفحة الإشعارات (أو في Header Dropdown)
2. اضغط "تحديد الكل كمقروء"
3. أكد العملية

النتيجة المتوقعة:
✅ جميع الإشعارات تصبح مقروءة
✅ Badge العداد في Header يختفي
✅ Badge "جديد" يختفي من جميع الإشعارات
✅ الألوان الزرقاء تتحول لعادية
```

### **حذف إشعار:**
```
1. في صفحة الإشعارات
2. انقر على أيقونة الحذف (سلة المهملات) بجانب أي إشعار
3. أكد الحذف

النتيجة المتوقعة:
✅ رسالة تأكيد
✅ الإشعار يختفي من القائمة
✅ العداد ينخفض بواحد
```

---

## ⏱️ اختبار Real-time Updates

### **اختبار التحديث التلقائي:**
```
1. افتح صفحة الطالب في متصفح
2. افتح صفحة الأدمن في متصفح آخر (أو نافذة Incognito)
3. في صفحة الأدمن: أصدر شهادة جديدة للطالب
4. ارجع لصفحة الطالب وانتظر (بدون تحديث الصفحة)

النتيجة المتوقعة (خلال 3 ثواني):
✅ Badge في Header يتحدث ويزيد العدد
✅ Browser Notification تظهر
✅ صوت إشعار يُسمع
✅ إذا كان Dropdown مفتوح → الإشعار الجديد يظهر فوراً
```

---

## 📧 اختبار البريد الإلكتروني

### **الإعداد:**
```env
# في ملف .env
MAIL_MAILER=smtp
MAIL_HOST=smtp.mailtrap.io  # أو أي SMTP server
MAIL_PORT=2525
MAIL_USERNAME=your_username
MAIL_PASSWORD=your_password
```

### **الاختبار:**
```
1. تأكد من إعدادات SMTP في .env
2. أصدر شهادة جديدة
3. افتح Mailtrap (أو بريدك الإلكتروني)

النتيجة المتوقعة:
✅ إيميل جديد بعنوان "🎓 مبروك! تم إصدار شهادتك"
✅ المحتوى باللغة العربية
✅ يحتوي على:
   - اسم الطالب
   - اسم الكورس
   - رقم الشهادة
   - تاريخ الإصدار
   - زر "عرض الشهادة"
✅ الزر يعمل → يذهب لصفحة الشهادة
```

---

## 🔔 اختبار Browser Notifications

### **تفعيل الإشعارات:**
```
1. افتح صفحة الطالب
2. يجب أن يظهر طلب إذن للإشعارات
3. اضغط "السماح"
```

### **الاختبار:**
```
1. أصدر شهادة جديدة (أو أي إشعار)
2. انتظر بضع ثوان

النتيجة المتوقعة:
✅ إشعار يظهر من المتصفح (حتى لو كان في tab آخر)
✅ يحتوي على:
   - العنوان: "🎓 تم إصدار شهادتك!"
   - الرسالة: "تهانينا! تم إصدار شهادة..."
✅ صوت إشعار يُسمع
```

---

## 🐛 استكشاف الأخطاء

### **المشكلة: Badge لا يظهر في Header**
```
✅ تحقق من:
1. هل الطالب لديه إشعارات غير مقروءة؟
   → افحص: User::find(X)->gamificationNotifications()->unread()->count()
2. هل الملف main-header.blade.php محدّث؟
3. مسح الـ cache: php artisan view:clear
```

### **المشكلة: الإيميل لا يُرسل**
```
✅ تحقق من:
1. إعدادات .env صحيحة
2. جرب: php artisan tinker → Mail::raw('Test', function($msg) { $msg->to('test@test.com'); })
3. تأكد من أن Queue يعمل: php artisan queue:work
```

### **المشكلة: Real-time Updates لا تعمل**
```
✅ تحقق من:
1. افتح Console في المتصفح → هل هناك أخطاء JavaScript?
2. تأكد من أن الـ routes تعمل:
   → /student/gamification/notifications/api/unread-count
3. مسح الـ cache: php artisan cache:clear
```

### **المشكلة: فلتر "الشهادات" لا يظهر**
```
✅ تحقق من:
1. هل تم تحديث ملف index.blade.php؟
2. مسح الـ cache: php artisan view:clear
3. حدّث الصفحة بـ Ctrl+F5 (Hard Reload)
```

---

## ✅ قائمة التحقق النهائية

| المكون | تم الاختبار | يعمل |
|--------|-------------|------|
| صفحة الإشعارات | ☐ | ☐ |
| Header Badge | ☐ | ☐ |
| Header Dropdown | ☐ | ☐ |
| Sidebar Link | ☐ | ☐ |
| فلتر "الشهادات" | ☐ | ☐ |
| فلتر "غير المقروءة" | ☐ | ☐ |
| تحديد كمقروء | ☐ | ☐ |
| تحديد الكل كمقروء | ☐ | ☐ |
| حذف إشعار | ☐ | ☐ |
| إصدار شهادة → إشعار داخلي | ☐ | ☐ |
| إصدار شهادة → إيميل | ☐ | ☐ |
| Real-time Updates | ☐ | ☐ |
| Browser Notifications | ☐ | ☐ |
| Sound Alert | ☐ | ☐ |

---

## 📝 ملاحظات

### **للأدمن:**
- يمكن إرسال إشعارات مخصصة من: `/admin/notifications`
- يدعم إرسال لطالب واحد / مجموعة / كورس / الجميع

### **للمطور:**
- جميع الإشعارات تُسجل في `gamification_notifications`
- الإيميلات تُسجل في `notifications` (Laravel)
- Queue مدعوم: استخدم `php artisan queue:work`
- Logs في: `storage/logs/laravel.log`

### **للطالب:**
- الإشعارات تظهر فوراً (خلال 3 ثواني)
- يمكن حذف الإشعارات القديمة
- يمكن تحديد الكل كمقروء
- Browser Notifications تحتاج إذن من المتصفح

---

**إذا جميع الاختبارات نجحت → النظام يعمل بنجاح! ✅**
