# 📚 دليل استخدام لوحة تحكم Webhooks - للمشرفين

## 🎯 نظرة عامة

تم إنشاء نظام متكامل لإدارة Webhooks الواردة من WPForms (WordPress) مع واجهة إدارة احترافية كاملة.

---

## 📍 الوصول إلى النظام

### الروابط الرئيسية:

1. **لوحة التحكم الرئيسية**: `/admin/webhooks`
2. **جميع الإرساليات**: `/admin/webhooks/submissions`
3. **سجلات Webhooks**: `/admin/webhooks/logs`

### الوصول عبر القائمة الجانبية:

```
القائمة الجانبية → التكاملات → Webhooks
```

---

## 🏠 لوحة التحكم الرئيسية

### الإحصائيات المعروضة:

#### 1. البطاقات الإحصائية (في الأعلى)
- **إجمالي الإرساليات**: عدد جميع الإرساليات المستلمة
- **قيد المعالجة**: الإرساليات التي لم تتم معالجتها بعد
- **تمت المعالجة**: الإرساليات المعالجة بنجاح
- **الفاشلة**: الإرساليات التي فشلت معالجتها

#### 2. إحصائيات الفترة
- **اليوم**: إرساليات اليوم فقط
- **هذا الأسبوع**: إرساليات الأسبوع الحالي

#### 3. الإرساليات حسب النوع
توزيع الإرساليات على الأنواع:
- 📝 **تسجيل** (enrollment) - تسجيل الطلاب في الكورسات
- ✉️ **تواصل** (contact) - رسائل التواصل
- ⭐ **مراجعة** (review) - مراجعات الكورسات
- 💰 **دفع** (payment) - عمليات الدفع
- 📋 **طلب** (application) - طلبات الالتحاق
- 📊 **استبيان** (survey) - الاستبيانات

#### 4. أحدث الإرساليات (10 إرساليات)
جدول يعرض:
- رقم الإرسالية
- النوع
- Form ID
- اسم الطالب
- اسم الكورس
- الحالة
- التاريخ
- زر العرض وإعادة المحاولة (للفاشلة)

#### 5. أحدث السجلات (10 سجلات)
جدول يعرض آخر طلبات Webhooks المستلمة

---

## 📥 صفحة الإرساليات

### الفلترة المتقدمة:

#### 1. حسب الحالة
```
- الكل
- معلق (pending)
- تمت المعالجة (processed)
- فاشل (failed)
```

#### 2. حسب النوع
```
- الكل
- تسجيل
- تواصل
- مراجعة
- دفع
- طلب التحاق
- استبيان
```

#### 3. البحث
- البحث برقم **Form ID**
- البحث برقم **Entry ID**

### الميزات:

✅ **Pagination**: عرض 20 إرسالية في الصفحة
✅ **تصدير**: تصدير النتائج إلى ملف CSV
✅ **الفرز**: حسب الأحدث أولاً
✅ **الإجراءات السريعة**: عرض تفاصيل أو إعادة محاولة

---

## 🔍 صفحة تفاصيل إرسالية واحدة

### القسم الأيسر (المعلومات الأساسية):

#### 1. نوع الإرسالية وحالتها
- **نوع الإرسالية** مع أيقونة ملونة وتصنيف واضح
- **الحالة** (معلق/تمت المعالجة/فاشل) مع Badge ملون

#### 2. معلومات النموذج
- **Form ID**: معرّف النموذج في WPForms
- **Entry ID**: معرّف الإدخال
- **تاريخ الاستلام**: متى تم استلام البيانات
- **آخر تحديث**: آخر مرة تم تحديث الإرسالية

#### 3. بيانات النموذج - **العرض الذكي الجديد!**

**الميزات الجديدة**:

##### أ) فرز الحقول حسب الأهمية
- **الحقول المهمة** تظهر أولاً وفي عمودين (50% للعمود)
  - الاسم
  - البريد الإلكتروني
  - الهاتف
  - الكورس

- **الحقول العادية** تظهر في عمود واحد كامل (100%)

##### ب) الأيقونات الذكية
كل حقل له أيقونة مناسبة تلقائياً:
- 👤 الاسم → أيقونة مستخدم
- ✉️ البريد → أيقونة مظروف
- 📱 الهاتف → أيقونة هاتف
- 📚 الكورس → أيقونة كتاب
- 💬 الرسالة → أيقونة تعليق
- ⭐ التقييم → أيقونة نجمة
- 💵 المبلغ → أيقونة دولار
- 📅 التاريخ → أيقونة تقويم
- وغيرها...

##### ج) تنسيق القيم التلقائي
- **البريد الإلكتروني** → رابط قابل للنقر (mailto:)
- **الروابط** → رابط يفتح في نافذة جديدة
- **النصوص الطويلة** → يعرض 200 حرف + زر "عرض المزيد"
- **القيم المنطقية** → Badge "نعم" أو "لا"
- **الأرقام العشرية** → تنسيق بفواصل

##### د) التصميم المميز
- **الحقول المهمة**: خلفية ملونة + حد أزرق على اليمين + Badge "مهم"
- **تأثير Hover**: ظل خفيف وحركة للأعلى عند المرور بالماوس
- **تدرج لوني**: خلفية بتدرج أنيق للحقول المهمة

#### 4. ملاحظات المعالجة
- تظهر إذا كانت هناك ملاحظات (نجاح أو خطأ)
- **نجاح**: خلفية خضراء
- **فشل**: خلفية حمراء مع رسالة الخطأ

### القسم الأيمن (Sidebar):

#### 1. الطالب المرتبط
- **الصورة الافتراضية**: دائرة ملونة بأول حرف من الاسم
- **الاسم**
- **البريد الإلكتروني**
- **رقم المستخدم**
- **تاريخ التسجيل**
- **زر**: عرض ملف الطالب

#### 2. الكورس المرتبط
- **صورة الكورس** (إن وجدت)
- **عنوان الكورس**
- **وصف مختصر**
- **رقم الكورس**
- **اسم المدرب**
- **زر**: عرض الكورس

#### 3. الإجراءات
- **إعادة المحاولة** (للإرساليات الفاشلة فقط)
- **جميع الإرساليات**
- **لوحة التحكم**

---

## 📝 صفحة سجلات Webhooks

### الفلترة:

#### 1. حسب الحالة
```
- الكل
- مستلم (received)
- معالج (processed)
- فاشل (failed)
```

#### 2. حسب المصدر
```
- الكل
- wpforms
- stripe
- paypal
```

### الجدول يعرض:
- رقم السجل
- المصدر
- الحالة
- الرسالة (مع رسالة الخطأ إن وجدت)
- IP Address
- التاريخ
- زر عرض التفاصيل

### الإحصائيات السريعة (أسفل الصفحة):
- مجموع السجلات
- معالجة بنجاح
- فاشلة
- آخر 24 ساعة

### ميزة التنظيف:
زر **"تنظيف السجلات"** لحذف السجلات القديمة:
- 7 أيام
- 14 يوم
- 30 يوم
- 60 يوم
- 90 يوم
- 180 يوم

⚠️ **تحذير**: لا يمكن التراجع عن الحذف!

---

## 🔎 صفحة تفاصيل سجل واحد

### المعلومات المعروضة:

#### 1. معلومات أساسية
- المصدر والحالة
- IP Address
- User Agent
- تاريخ الاستلام
- رقم السجل
- الرسالة

#### 2. رسالة الخطأ (إن وجدت)
بطاقة حمراء تعرض تفاصيل الخطأ بالكامل

#### 3. البيانات المرسلة (Payload)
- عرض JSON منسق وجميل
- **زر "نسخ"** لنسخ المحتوى بنقرة واحدة
- تنبيه تلقائي بعد النسخ

#### 4. HTTP Headers
- جميع Headers المستلمة
- **زر "نسخ"** للنسخ
- عرض منسق وسهل القراءة

#### 5. الاستجابة (Response)
- عرض استجابة النظام (إن وجدت)

#### 6. Timeline زمني
مخطط زمني يوضح:
1. **استلام الطلب** → Badge أزرق
2. **معالجة ناجحة** → Badge أخضر
   OR
   **فشل المعالجة** → Badge أحمر

---

## 🎨 الألوان والأيقونات

### حالات الإرساليات:

| الحالة | اللون | الأيقونة |
|--------|-------|----------|
| معلق (pending) | أصفر | ⏱️ ساعة |
| تمت المعالجة (processed) | أخضر | ✅ صح |
| فاشل (failed) | أحمر | ⚠️ تحذير |

### أنواع الإرساليات:

| النوع | اللون | الأيقونة |
|-------|-------|----------|
| تسجيل (enrollment) | أزرق | 👤 مستخدم+ |
| تواصل (contact) | سماوي | ✉️ مظروف |
| مراجعة (review) | أصفر | ⭐ نجمة |
| دفع (payment) | أخضر | 💵 فلوس |
| طلب (application) | رمادي | 📋 ورقة |
| استبيان (survey) | أسود | 📊 استطلاع |

---

## 🔄 إعادة محاولة الإرساليات الفاشلة

### متى تستخدم "إعادة المحاولة"؟

#### السيناريو 1: الكورس غير موجود
```
1. إرسالية فشلت لأن الكورس "Laravel Advanced" غير موجود
2. قم بإضافة الكورس في النظام
3. اذهب إلى تفاصيل الإرسالية
4. اضغط "إعادة المحاولة"
5. سيتم تسجيل الطالب تلقائياً
```

#### السيناريو 2: بيانات ناقصة
```
1. إرسالية فشلت لأن البريد الإلكتروني غير صحيح
2. لا يمكن إعادة المحاولة (يجب تصحيح البيانات من WordPress)
3. يمكنك تسجيل الطالب يدوياً من البيانات المعروضة
```

### كيف تعمل "إعادة المحاولة"؟

```php
1. يتم إنشاء طلب وهمي بنفس البيانات الأصلية
2. يتم تمرير الطلب إلى WebhookController
3. يتم معالجة البيانات مرة أخرى من البداية
4. إذا نجحت: تتحول الحالة إلى "processed"
5. إذا فشلت: تبقى "failed" مع رسالة خطأ جديدة
```

---

## 📤 تصدير البيانات إلى CSV

### كيفية التصدير:

#### من صفحة الإرساليات:
```
1. اختر الفلاتر المطلوبة (حالة، نوع، بحث)
2. اضغط "تصدير النتائج"
3. سيتم تنزيل ملف CSV فوراً
```

### البيانات المُصدَّرة:
```csv
ID, Form ID, Entry ID, Type, Status, User, Course, Created At
```

### اسم الملف:
```
webhook_submissions_2025-11-28_14-30-45.csv
```

### الاستخدام:
- **Excel**: افتح الملف مباشرة
- **Google Sheets**: استيراد → ملف CSV
- **تحليل البيانات**: استخدم Python/R للتحليل

---

## 🧹 تنظيف السجلات القديمة

### لماذا التنظيف؟

1. **تحسين الأداء**: قاعدة بيانات أسرع
2. **توفير المساحة**: حذف البيانات غير الضرورية
3. **سهولة البحث**: سجلات أقل = بحث أسرع

### التوصيات:

| الفترة | الاستخدام |
|--------|-----------|
| 7 أيام | للاختبار فقط |
| 30 يوم | **مُوصى به للإنتاج** |
| 90 يوم | إذا كنت تحتاج سجلات طويلة |
| 180 يوم | للأرشفة والامتثال |

### الخطوات:

```
1. اذهب إلى "سجلات Webhooks"
2. اضغط "تنظيف السجلات"
3. اختر الفترة (30 يوم مثلاً)
4. أكّد الحذف
5. سترى رسالة: "تم حذف X سجل قديم"
```

⚠️ **تحذير**: السجلات المحذوفة لا يمكن استرجاعها!

💡 **نصيحة**: قم بالتنظيف شهرياً للحفاظ على الأداء

---

## 🔍 البحث والفلترة

### أمثلة عملية:

#### مثال 1: البحث عن إرساليات طالب معين
```
1. اذهب إلى "الإرساليات"
2. ابحث بالبريد الإلكتروني (لن يعمل حالياً)
3. أو افتح كل إرسالية وابحث يدوياً
```

💡 **تطوير مستقبلي**: إضافة بحث بالبريد والاسم

#### مثال 2: جميع التسجيلات الفاشلة
```
1. اذهب إلى "الإرساليات"
2. الحالة = "فاشل"
3. النوع = "تسجيل"
4. اضغط "بحث"
```

#### مثال 3: جميع رسائل التواصل اليوم
```
1. اذهب إلى "لوحة التحكم"
2. انظر إلى "إحصائيات الفترة → اليوم"
3. ثم اذهب إلى "الإرساليات"
4. فلتر بـ "تواصل"
```

---

## 📊 قراءة الإحصائيات

### مثال تحليلي:

```
📈 لوحة التحكم تعرض:
- إجمالي الإرساليات: 250
- معلقة: 5
- معالجة: 230
- فاشلة: 15

📊 التحليل:
- معدل النجاح: 230/250 = 92%
- معدل الفشل: 15/250 = 6%
- قيد المعالجة: 5/250 = 2%

✅ النتيجة: النظام يعمل بكفاءة 92%

🔧 الإجراء المطلوب:
- مراجعة الـ 15 إرسالية الفاشلة
- معالجة الـ 5 المعلقة
```

---

## 🎯 أفضل الممارسات

### 1. المراجعة اليومية
```
✅ افتح لوحة التحكم يومياً
✅ تحقق من الإرساليات الفاشلة
✅ عالج الإرساليات المعلقة
```

### 2. الصيانة الأسبوعية
```
✅ راجع جميع الإرساليات
✅ تأكد من معالجة كل شيء
✅ راجع السجلات للأخطاء المتكررة
```

### 3. الصيانة الشهرية
```
✅ نظّف السجلات القديمة (30+ يوم)
✅ صدّر الإحصائيات للتحليل
✅ راجع معدلات النجاح والفشل
```

### 4. الأمان
```
✅ راجع IP Addresses المسموح بها
✅ غيّر API Key دورياً
✅ راقب الطلبات المشبوهة
```

---

## ❓ الأسئلة الشائعة

### س1: لماذا إرسالية معينة فاشلة؟
**ج**: افتح تفاصيل الإرسالية واقرأ "ملاحظات المعالجة" - ستجد السبب الدقيق.

### س2: كيف أحذف إرسالية؟
**ج**: حالياً لا توجد ميزة حذف (للأمان). يمكنك تجاهلها أو تطوير الميزة لاحقاً.

### س3: هل يمكنني تعديل البيانات المرسلة؟
**ج**: لا، البيانات للقراءة فقط. يجب تعديل النموذج في WordPress وإعادة الإرسال.

### س4: ماذا يعني "معلق" (pending)؟
**ج**: تم استلام البيانات لكن لم تتم معالجتها بعد (نادر الحدوث).

### س5: كيف أعرف من أي نموذج جاءت الإرسالية؟
**ج**: انظر إلى **Form ID** - كل نموذج في WPForms له رقم فريد.

### س6: هل يمكنني تصدير السجلات؟
**ج**: حالياً التصدير للإرساليات فقط، ليس السجلات. يمكن تطوير ذلك لاحقاً.

---

## 🚀 ميزات مستقبلية مقترحة

### 1. البحث المتقدم
- البحث بالبريد الإلكتروني
- البحث بالاسم
- البحث بالهاتف

### 2. الإحصائيات المتقدمة
- رسوم بيانية (Charts)
- تقارير شهرية
- معدلات النجاح/الفشل

### 3. الإشعارات
- إشعار عند إرسالية جديدة
- إشعار عند فشل معالجة
- إشعار يومي بالإحصائيات

### 4. التكاملات الإضافية
- Stripe Webhooks
- PayPal Webhooks
- Zoom Webhooks

### 5. الأتمتة
- إعادة محاولة تلقائية للفاشلة
- تنظيف تلقائي شهري
- تصدير تلقائي للتقارير

---

## 📞 الدعم والمساعدة

إذا واجهت أي مشكلة:

1. **راجع السجلات**: `/admin/webhooks/logs`
2. **تحقق من Laravel Logs**: `storage/logs/laravel.log`
3. **اختبر الـ Endpoint**: `curl https://yourdomain.com/api/webhooks/test`
4. **راجع الوثائق**: `WPFORMS_INTEGRATION_README.md`

---

## ✅ الخلاصة

لديك الآن نظام إدارة Webhooks متكامل مع:

- ✅ واجهة مستخدم احترافية
- ✅ فلترة وبحث متقدم
- ✅ عرض ذكي للبيانات
- ✅ إحصائيات شاملة
- ✅ إعادة محاولة للفاشلة
- ✅ تصدير CSV
- ✅ تنظيف تلقائي

استمتع بإدارة Webhooks بكفاءة! 🎉
