<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Gamification Points Configuration
    |--------------------------------------------------------------------------
    |
    | تحديد النقاط المكتسبة لكل نشاط في النظام
    |
    */

    'points' => [
        // إتمام الدروس
        'lesson_completion' => [
            'points' => 50,
            'xp' => 25,
            'description' => 'إتمام درس',
        ],

        // مشاهدة الفيديوهات
        'video_watch' => [
            'points' => 30,
            'xp' => 15,
            'description' => 'مشاهدة فيديو (80% أو أكثر)',
            'min_watch_percentage' => 80,
        ],

        // إتمام الاختبارات
        'quiz_completion' => [
            'points' => 100,
            'xp' => 50,
            'description' => 'إتمام اختبار',
            'score_multipliers' => [
                'excellent' => 1.5,  // 90%+ (درجة ممتازة)
                'good' => 1.25,      // 75%+ (درجة جيدة)
                'pass' => 1.0,       // 50%+ (نجاح)
                'fail' => 0.5,       // أقل من 50% (رسوب)
            ],
        ],

        // الدرجة الكاملة
        'perfect_score' => [
            'points' => 200,
            'xp' => 100,
            'description' => 'مكافأة الدرجة الكاملة (100%)',
        ],

        // تسليم الواجبات
        'assignment_submission' => [
            'points' => 150,
            'xp' => 75,
            'description' => 'تسليم واجب',
        ],

        // إتمام كورس كامل
        'course_completion' => [
            'points' => 1000,
            'xp' => 500,
            'description' => 'إتمام كورس كامل',
        ],

        // تسجيل الدخول اليومي
        'daily_login' => [
            'points' => 10,
            'xp' => 5,
            'description' => 'تسجيل الدخول اليومي',
        ],

        // إضافة تعليق
        'comment_post' => [
            'points' => 5,
            'xp' => 2,
            'description' => 'إضافة تعليق',
            'daily_limit' => 10, // حد أقصى 10 تعليقات يومياً للحصول على نقاط
        ],

        // الحصول على إعجاب على تعليق
        'comment_like' => [
            'points' => 2,
            'xp' => 1,
            'description' => 'الحصول على إعجاب',
        ],

        // مشاركة كورس
        'course_share' => [
            'points' => 15,
            'xp' => 7,
            'description' => 'مشاركة كورس',
        ],

        // دعوة صديق
        'referral' => [
            'points' => 500,
            'xp' => 250,
            'description' => 'دعوة صديق (عند تسجيله)',
        ],

        // مكافآت السلسلة (معالم)
        'streak_milestones' => [
            7 => [
                'points' => 100,
                'description' => 'أسبوع من النشاط المتواصل',
            ],
            14 => [
                'points' => 250,
                'description' => 'أسبوعين من النشاط المتواصل',
            ],
            30 => [
                'points' => 500,
                'description' => 'شهر من النشاط المتواصل',
            ],
            60 => [
                'points' => 1000,
                'description' => 'شهرين من النشاط المتواصل',
            ],
            90 => [
                'points' => 2000,
                'description' => '3 أشهر من النشاط المتواصل',
            ],
            180 => [
                'points' => 5000,
                'description' => 'نصف سنة من النشاط المتواصل',
            ],
            365 => [
                'points' => 10000,
                'description' => 'سنة كاملة من النشاط المتواصل',
            ],
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Streak Multipliers
    |--------------------------------------------------------------------------
    |
    | مضاعفات النقاط بناءً على سلسلة النشاط اليومي
    |
    */

    'streak_multipliers' => [
        0 => 1.0,    // لا يوجد سلسلة
        3 => 1.1,    // 3 أيام: +10%
        7 => 1.2,    // أسبوع: +20%
        14 => 1.3,   // أسبوعين: +30%
        30 => 1.5,   // شهر: +50%
        60 => 1.7,   // شهرين: +70%
        90 => 1.9,   // 3 أشهر: +90%
        180 => 2.0,  // نصف سنة: +100%
    ],

    /*
    |--------------------------------------------------------------------------
    | Experience Levels
    |--------------------------------------------------------------------------
    |
    | معادلة حساب XP المطلوب لكل مستوى
    | Formula: XP = base * level^exponent
    |
    */

    'levels' => [
        'max_level' => 50,
        'base_xp' => 100,         // XP للمستوى 1
        'exponent' => 1.5,        // معامل الصعوبة
        'level_up_bonus_points' => 50, // نقاط مكافأة عند كل ترقية
    ],

    /*
    |--------------------------------------------------------------------------
    | Badge Rarity Points Value
    |--------------------------------------------------------------------------
    |
    | قيمة النقاط لكل نوع من الشارات
    |
    */

    'badge_rarity_points' => [
        'common' => 50,
        'rare' => 100,
        'epic' => 250,
        'legendary' => 500,
        'mythic' => 1000,
    ],

    /*
    |--------------------------------------------------------------------------
    | Achievement Tier Points
    |--------------------------------------------------------------------------
    |
    | قيمة النقاط لكل مرتبة إنجاز
    |
    */

    'achievement_tier_points' => [
        'bronze' => 100,
        'silver' => 200,
        'gold' => 400,
        'platinum' => 800,
        'diamond' => 1500,
    ],

    /*
    |--------------------------------------------------------------------------
    | Leaderboard Settings
    |--------------------------------------------------------------------------
    |
    | إعدادات لوحة المتصدرين
    |
    */

    'leaderboard' => [
        'entries_per_page' => 50,
        'update_frequency' => 3600, // تحديث كل ساعة (بالثواني)

        'divisions' => [
            'bronze' => [
                'min_points' => 0,
                'max_points' => 1000,
                'color' => '#CD7F32',
            ],
            'silver' => [
                'min_points' => 1001,
                'max_points' => 5000,
                'color' => '#C0C0C0',
            ],
            'gold' => [
                'min_points' => 5001,
                'max_points' => 15000,
                'color' => '#FFD700',
            ],
            'platinum' => [
                'min_points' => 15001,
                'max_points' => 50000,
                'color' => '#E5E4E2',
            ],
            'diamond' => [
                'min_points' => 50001,
                'max_points' => PHP_INT_MAX,
                'color' => '#B9F2FF',
            ],
        ],

        'rewards' => [
            'weekly' => [
                1 => ['points' => 1000, 'gems' => 100],
                2 => ['points' => 750, 'gems' => 75],
                3 => ['points' => 500, 'gems' => 50],
                'top_10' => ['points' => 250, 'gems' => 25],
            ],
            'monthly' => [
                1 => ['points' => 5000, 'gems' => 500],
                2 => ['points' => 3500, 'gems' => 350],
                3 => ['points' => 2500, 'gems' => 250],
                'top_10' => ['points' => 1000, 'gems' => 100],
            ],
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Challenge Settings
    |--------------------------------------------------------------------------
    |
    | إعدادات التحديات
    |
    */

    'challenges' => [
        'daily' => [
            'max_active' => 3,
            'reward_multiplier' => 1.0,
        ],
        'weekly' => [
            'max_active' => 5,
            'reward_multiplier' => 1.5,
        ],
        'monthly' => [
            'max_active' => 2,
            'reward_multiplier' => 2.0,
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Rewards Shop Categories
    |--------------------------------------------------------------------------
    |
    | فئات متجر المكافآت
    |
    */

    'reward_categories' => [
        'profile_customization' => 'تخصيص الملف الشخصي',
        'course_benefits' => 'مزايا الكورسات',
        'badges' => 'شارات حصرية',
        'certificates' => 'شهادات',
        'physical_rewards' => 'مكافآت حقيقية',
    ],

    /*
    |--------------------------------------------------------------------------
    | Points Expiration
    |--------------------------------------------------------------------------
    |
    | إعدادات انتهاء صلاحية النقاط
    |
    */

    'points_expiration' => [
        'enabled' => false,        // تفعيل انتهاء الصلاحية
        'days' => 365,            // عدد الأيام قبل الانتهاء
        'warning_days' => 30,     // تحذير قبل X يوم من الانتهاء
    ],

    /*
    |--------------------------------------------------------------------------
    | Activity Limits
    |--------------------------------------------------------------------------
    |
    | حدود النقاط اليومية لمنع الاستغلال
    |
    */

    'daily_limits' => [
        'max_points_per_day' => 5000,
        'max_xp_per_day' => 2500,
        'specific_activities' => [
            'comment_post' => 10,      // حد أقصى 10 تعليقات يومياً
            'comment_like' => 50,      // حد أقصى 50 إعجاب يومياً
            'video_watch' => 20,       // حد أقصى 20 فيديو يومياً
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Notifications
    |--------------------------------------------------------------------------
    |
    | إعدادات الإشعارات
    |
    */

    'notifications' => [
        'level_up' => true,
        'badge_earned' => true,
        'achievement_unlocked' => true,
        'streak_milestone' => true,
        'challenge_completed' => true,
        'leaderboard_rank_change' => true,
    ],

];
