<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Badge;

class BadgeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $badges = [
            // ========================================
            // Progress Badges (شارات التقدم)
            // ========================================
            [
                'name' => 'البداية الأولى',
                'slug' => 'first-lesson',
                'description' => 'أنهيت أول درس لك! خطوة صغيرة نحو رحلة كبيرة.',
                'icon' => '🎯',
                'type' => 'progress',
                'category' => 'lessons',
                'rarity' => 'common',
                'criteria' => ['lessons_completed' => 1],
                'points_value' => 10,
                'is_active' => true,
                'is_visible' => true,
                'is_hidden' => false,
                'sort_order' => 1,
            ],
            [
                'name' => 'متعلم نشيط',
                'slug' => 'active-learner',
                'description' => 'أنهيت 10 دروس. أنت في الطريق الصحيح!',
                'icon' => '📚',
                'type' => 'progress',
                'category' => 'lessons',
                'rarity' => 'common',
                'criteria' => ['lessons_completed' => 10],
                'points_value' => 50,
                'is_active' => true,
                'is_visible' => true,
                'is_hidden' => false,
                'sort_order' => 2,
            ],
            [
                'name' => 'عاشق التعلم',
                'slug' => 'learning-enthusiast',
                'description' => 'أنهيت 50 درساً! التعلم أصبح عادة بالنسبة لك.',
                'icon' => '📖',
                'type' => 'progress',
                'category' => 'lessons',
                'rarity' => 'rare',
                'criteria' => ['lessons_completed' => 50],
                'points_value' => 200,
                'is_active' => true,
                'is_visible' => true,
                'is_hidden' => false,
                'sort_order' => 3,
            ],
            [
                'name' => 'مدمن المعرفة',
                'slug' => 'knowledge-addict',
                'description' => 'أنهيت 100 درس! أنت تبني إمبراطورية معرفية.',
                'icon' => '🏆',
                'type' => 'progress',
                'category' => 'lessons',
                'rarity' => 'epic',
                'criteria' => ['lessons_completed' => 100],
                'points_value' => 500,
                'is_active' => true,
                'is_visible' => true,
                'is_hidden' => false,
                'sort_order' => 4,
            ],
            [
                'name' => 'أسطورة التعلم',
                'slug' => 'learning-legend',
                'description' => 'أنهيت 500 درس! أنت أسطورة حقيقية في التعلم.',
                'icon' => '👑',
                'type' => 'progress',
                'category' => 'lessons',
                'rarity' => 'legendary',
                'criteria' => ['lessons_completed' => 500],
                'points_value' => 2000,
                'is_active' => true,
                'is_visible' => true,
                'is_hidden' => false,
                'sort_order' => 5,
            ],

            // ========== Course Completion Badges ==========
            [
                'name' => 'أول إنجاز',
                'slug' => 'first-course',
                'description' => 'أنهيت أول كورس لك! هذا الإنجاز الأول من كثير قادم.',
                'icon' => '🎓',
                'type' => 'progress',
                'category' => 'courses',
                'rarity' => 'rare',
                'criteria' => ['courses_completed' => 1],
                'points_value' => 100,
                'is_active' => true,
                'is_visible' => true,
                'is_hidden' => false,
                'sort_order' => 10,
            ],
            [
                'name' => 'جامع الشهادات',
                'slug' => 'certificate-collector',
                'description' => 'أنهيت 5 كورسات! مجموعتك من الشهادات تكبر.',
                'icon' => '📜',
                'type' => 'progress',
                'category' => 'courses',
                'rarity' => 'epic',
                'criteria' => ['courses_completed' => 5],
                'points_value' => 500,
                'is_active' => true,
                'is_visible' => true,
                'is_hidden' => false,
                'sort_order' => 11,
            ],
            [
                'name' => 'خبير متعدد المجالات',
                'slug' => 'multi-skilled-expert',
                'description' => 'أنهيت 10 كورسات! أنت خبير في مجالات متعددة.',
                'icon' => '🌟',
                'type' => 'progress',
                'category' => 'courses',
                'rarity' => 'legendary',
                'criteria' => ['courses_completed' => 10],
                'points_value' => 1500,
                'is_active' => true,
                'is_visible' => true,
                'is_hidden' => false,
                'sort_order' => 12,
            ],

            // ========================================
            // Performance Badges (شارات الأداء)
            // ========================================
            [
                'name' => 'الدرجة الكاملة',
                'slug' => 'perfect-score',
                'description' => 'حصلت على درجة كاملة في اختبار! إتقان مثالي.',
                'icon' => '💯',
                'type' => 'performance',
                'category' => 'quizzes',
                'rarity' => 'rare',
                'criteria' => ['perfect_scores' => 1],
                'points_value' => 100,
                'is_active' => true,
                'is_visible' => true,
                'is_hidden' => false,
                'sort_order' => 20,
            ],
            [
                'name' => 'مسلسل الدرجات الكاملة',
                'slug' => 'perfect-streak',
                'description' => 'حصلت على 5 درجات كاملة! الإتقان هو سلاحك.',
                'icon' => '🔥',
                'type' => 'performance',
                'category' => 'quizzes',
                'rarity' => 'epic',
                'criteria' => ['perfect_scores' => 5],
                'points_value' => 500,
                'is_active' => true,
                'is_visible' => true,
                'is_hidden' => false,
                'sort_order' => 21,
            ],
            [
                'name' => 'المتقن المطلق',
                'slug' => 'absolute-master',
                'description' => 'حصلت على 20 درجة كاملة! لا يوجد اختبار يقاومك.',
                'icon' => '⭐',
                'type' => 'performance',
                'category' => 'quizzes',
                'rarity' => 'legendary',
                'criteria' => ['perfect_scores' => 20],
                'points_value' => 2000,
                'is_active' => true,
                'is_visible' => true,
                'is_hidden' => false,
                'sort_order' => 22,
            ],
            [
                'name' => 'عبقري الاختبارات',
                'slug' => 'quiz-genius',
                'description' => 'أنهيت 50 اختباراً بنجاح. أنت عبقري في الاختبارات!',
                'icon' => '🧠',
                'type' => 'performance',
                'category' => 'quizzes',
                'rarity' => 'epic',
                'criteria' => ['quizzes_completed' => 50],
                'points_value' => 750,
                'is_active' => true,
                'is_visible' => true,
                'is_hidden' => false,
                'sort_order' => 23,
            ],

            // ========================================
            // Engagement Badges (شارات التفاعل)
            // ========================================
            [
                'name' => 'أسبوع من النشاط',
                'slug' => 'week-streak',
                'description' => 'سجلت دخول لمدة 7 أيام متتالية! الانضباط هو سر النجاح.',
                'icon' => '🔥',
                'type' => 'engagement',
                'category' => 'streaks',
                'rarity' => 'common',
                'criteria' => ['current_streak' => 7],
                'points_value' => 100,
                'is_active' => true,
                'is_visible' => true,
                'is_hidden' => false,
                'sort_order' => 30,
            ],
            [
                'name' => 'شهر من الالتزام',
                'slug' => 'month-streak',
                'description' => 'سجلت دخول لمدة 30 يوماً متتالية! أنت ملتزم حقاً.',
                'icon' => '🌟',
                'type' => 'engagement',
                'category' => 'streaks',
                'rarity' => 'epic',
                'criteria' => ['current_streak' => 30],
                'points_value' => 500,
                'is_active' => true,
                'is_visible' => true,
                'is_hidden' => false,
                'sort_order' => 31,
            ],
            [
                'name' => '100 يوم من التميز',
                'slug' => 'hundred-day-streak',
                'description' => 'سجلت دخول لمدة 100 يوم متتالي! أنت نموذج للانضباط.',
                'icon' => '💎',
                'type' => 'engagement',
                'category' => 'streaks',
                'rarity' => 'legendary',
                'criteria' => ['current_streak' => 100],
                'points_value' => 2000,
                'is_active' => true,
                'is_visible' => true,
                'is_hidden' => false,
                'sort_order' => 32,
            ],
            [
                'name' => 'السنة الذهبية',
                'slug' => 'golden-year',
                'description' => 'سجلت دخول لمدة 365 يوماً متتالية! إنجاز أسطوري!',
                'icon' => '👑',
                'type' => 'engagement',
                'category' => 'streaks',
                'rarity' => 'mythic',
                'criteria' => ['current_streak' => 365],
                'points_value' => 10000,
                'is_active' => true,
                'is_visible' => true,
                'is_hidden' => false,
                'sort_order' => 33,
            ],

            // ========================================
            // Special Badges (شارات خاصة)
            // ========================================
            [
                'name' => 'الطالب المثالي',
                'slug' => 'perfect-student',
                'description' => 'حققت التفوق في جميع الجوانب! أنت الطالب المثالي.',
                'icon' => '🏅',
                'type' => 'special',
                'category' => 'overall',
                'rarity' => 'mythic',
                'criteria' => [
                    'courses_completed' => 10,
                    'perfect_scores' => 20,
                    'current_streak' => 30,
                ],
                'points_value' => 5000,
                'is_active' => true,
                'is_visible' => true,
                'is_hidden' => false,
                'sort_order' => 40,
            ],
            [
                'name' => 'صياد الشارات',
                'slug' => 'badge-hunter',
                'description' => 'جمعت 25 شارة! أنت جامع حقيقي للإنجازات.',
                'icon' => '🎖️',
                'type' => 'special',
                'category' => 'badges',
                'rarity' => 'epic',
                'criteria' => ['total_badges' => 25],
                'points_value' => 1000,
                'is_active' => true,
                'is_visible' => true,
                'is_hidden' => false,
                'sort_order' => 41,
            ],
            [
                'name' => 'ملك الشارات',
                'slug' => 'badge-king',
                'description' => 'جمعت 50 شارة! أنت ملك الإنجازات.',
                'icon' => '👑',
                'type' => 'special',
                'category' => 'badges',
                'rarity' => 'legendary',
                'criteria' => ['total_badges' => 50],
                'points_value' => 3000,
                'is_active' => true,
                'is_visible' => true,
                'is_hidden' => false,
                'sort_order' => 42,
            ],
            [
                'name' => 'المليونير',
                'slug' => 'millionaire',
                'description' => 'جمعت 10,000 نقطة! ثروتك من النقاط مذهلة.',
                'icon' => '💰',
                'type' => 'special',
                'category' => 'points',
                'rarity' => 'epic',
                'criteria' => ['total_points' => 10000],
                'points_value' => 1000,
                'is_active' => true,
                'is_visible' => true,
                'is_hidden' => false,
                'sort_order' => 43,
            ],
            [
                'name' => 'المستوى الأعلى',
                'slug' => 'level-master',
                'description' => 'وصلت إلى المستوى 50! أنت في القمة.',
                'icon' => '🚀',
                'type' => 'special',
                'category' => 'levels',
                'rarity' => 'mythic',
                'criteria' => ['current_level' => 50],
                'points_value' => 5000,
                'is_active' => true,
                'is_visible' => true,
                'is_hidden' => false,
                'sort_order' => 44,
            ],

            // ========================================
            // Social & Event Badges (شارات اجتماعية)
            // ========================================
            [
                'name' => 'المتحدث',
                'slug' => 'communicator',
                'description' => 'أضفت 10 تعليقات مفيدة. صوتك مسموع!',
                'icon' => '💬',
                'type' => 'social',
                'category' => 'comments',
                'rarity' => 'common',
                'criteria' => ['comments_posted' => 10],
                'points_value' => 50,
                'is_active' => true,
                'is_visible' => true,
                'is_hidden' => false,
                'sort_order' => 50,
            ],
            [
                'name' => 'الداعم',
                'slug' => 'supporter',
                'description' => 'أحضرت 3 أصدقاء للمنصة. شكراً لدعمك!',
                'icon' => '🤝',
                'type' => 'social',
                'category' => 'referrals',
                'rarity' => 'rare',
                'criteria' => ['referrals_count' => 3],
                'points_value' => 300,
                'is_active' => true,
                'is_visible' => true,
                'is_hidden' => false,
                'sort_order' => 51,
            ],

            // ========================================
            // Level Milestone Badges
            // ========================================
            [
                'name' => 'مستوى العشرة',
                'slug' => 'level-10',
                'description' => 'وصلت إلى المستوى 10! رحلتك بدأت بقوة.',
                'icon' => '🔟',
                'type' => 'progress',
                'category' => 'levels',
                'rarity' => 'rare',
                'criteria' => ['current_level' => 10],
                'points_value' => 200,
                'is_active' => true,
                'is_visible' => true,
                'is_hidden' => false,
                'sort_order' => 60,
            ],
            [
                'name' => 'مستوى الخمسة والعشرين',
                'slug' => 'level-25',
                'description' => 'وصلت إلى المستوى 25! أنت في منتصف الطريق.',
                'icon' => '🎯',
                'type' => 'progress',
                'category' => 'levels',
                'rarity' => 'epic',
                'criteria' => ['current_level' => 25],
                'points_value' => 500,
                'is_active' => true,
                'is_visible' => true,
                'is_hidden' => false,
                'sort_order' => 61,
            ],

            // ========================================
            // Hidden Badges (شارات مخفية)
            // ========================================
            [
                'name' => 'بومة الليل',
                'slug' => 'night-owl',
                'description' => 'أنهيت 10 دروس بعد منتصف الليل. الليل لك!',
                'icon' => '🦉',
                'type' => 'special',
                'category' => 'time',
                'rarity' => 'rare',
                'criteria' => null, // يتم منحها يدوياً
                'points_value' => 200,
                'is_active' => true,
                'is_visible' => true,
                'is_hidden' => true, // مخفية
                'sort_order' => 70,
            ],
            [
                'name' => 'الطائر المبكر',
                'slug' => 'early-bird',
                'description' => 'أنهيت 10 دروس قبل الساعة 6 صباحاً. الصباح لك!',
                'icon' => '🐦',
                'type' => 'special',
                'category' => 'time',
                'rarity' => 'rare',
                'criteria' => null,
                'points_value' => 200,
                'is_active' => true,
                'is_visible' => true,
                'is_hidden' => true,
                'sort_order' => 71,
            ],
            [
                'name' => 'المتعلم السريع',
                'slug' => 'speed-learner',
                'description' => 'أنهيت كورساً كاملاً في أقل من 3 أيام! سرعة مذهلة.',
                'icon' => '⚡',
                'type' => 'special',
                'category' => 'speed',
                'rarity' => 'epic',
                'criteria' => null,
                'points_value' => 500,
                'is_active' => true,
                'is_visible' => true,
                'is_hidden' => true,
                'sort_order' => 72,
            ],
        ];

        foreach ($badges as $badge) {
            Badge::updateOrCreate(
                ['slug' => $badge['slug']],
                $badge
            );
        }

        $this->command->info('✅ تم إنشاء ' . count($badges) . ' شارة بنجاح!');
    }
}
