<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Challenge;

class ChallengeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $challenges = [
            // ========================================
            // Daily Challenges (تحديات يومية)
            // ========================================
            [
                'name' => 'المتعلم اليومي',
                'slug' => 'daily-learner',
                'description' => 'أكمل 3 دروس اليوم',
                'type' => 'daily',
                'difficulty' => 'easy',
                'icon' => '📚',
                'target_type' => 'lessons_completed',
                'target_value' => 3,
                'reward_points' => 100,
                'reward_xp' => 50,
                'reward_gems' => 10,
                'badge_id' => null,
                'is_active' => true,
                'auto_assign' => true,
                'sort_order' => 1,
            ],
            [
                'name' => 'ماراثون الفيديوهات',
                'slug' => 'video-marathon',
                'description' => 'شاهد 5 فيديوهات كاملة اليوم',
                'type' => 'daily',
                'difficulty' => 'easy',
                'icon' => '🎥',
                'target_type' => 'videos_watched',
                'target_value' => 5,
                'reward_points' => 80,
                'reward_xp' => 40,
                'reward_gems' => 8,
                'badge_id' => null,
                'is_active' => true,
                'auto_assign' => true,
                'sort_order' => 2,
            ],
            [
                'name' => 'بطل الاختبارات',
                'slug' => 'quiz-champion-daily',
                'description' => 'اجتز اختبارين بنجاح اليوم',
                'type' => 'daily',
                'difficulty' => 'medium',
                'icon' => '🏆',
                'target_type' => 'quizzes_passed',
                'target_value' => 2,
                'reward_points' => 150,
                'reward_xp' => 75,
                'reward_gems' => 15,
                'badge_id' => null,
                'is_active' => true,
                'auto_assign' => true,
                'sort_order' => 3,
            ],
            [
                'name' => 'الكمال اليومي',
                'slug' => 'daily-perfection',
                'description' => 'احصل على درجة كاملة في اختبار واحد اليوم',
                'type' => 'daily',
                'difficulty' => 'hard',
                'icon' => '💯',
                'target_type' => 'perfect_scores',
                'target_value' => 1,
                'reward_points' => 200,
                'reward_xp' => 100,
                'reward_gems' => 20,
                'badge_id' => null,
                'is_active' => true,
                'auto_assign' => false,
                'sort_order' => 4,
            ],
            [
                'name' => 'جامع النقاط',
                'slug' => 'point-collector-daily',
                'description' => 'اكسب 500 نقطة اليوم',
                'type' => 'daily',
                'difficulty' => 'medium',
                'icon' => '💰',
                'target_type' => 'points_earned',
                'target_value' => 500,
                'reward_points' => 100,
                'reward_xp' => 50,
                'reward_gems' => 10,
                'badge_id' => null,
                'is_active' => true,
                'auto_assign' => true,
                'sort_order' => 5,
            ],

            // ========================================
            // Weekly Challenges (تحديات أسبوعية)
            // ========================================
            [
                'name' => 'أسبوع الإنتاجية',
                'slug' => 'productivity-week',
                'description' => 'أكمل 20 درساً هذا الأسبوع',
                'type' => 'weekly',
                'difficulty' => 'medium',
                'icon' => '🚀',
                'target_type' => 'lessons_completed',
                'target_value' => 20,
                'reward_points' => 800,
                'reward_xp' => 400,
                'reward_gems' => 80,
                'badge_id' => null,
                'is_active' => true,
                'auto_assign' => false,
                'sort_order' => 10,
            ],
            [
                'name' => 'ماستر الاختبارات',
                'slug' => 'quiz-master-weekly',
                'description' => 'اجتز 10 اختبارات هذا الأسبوع',
                'type' => 'weekly',
                'difficulty' => 'hard',
                'icon' => '🎓',
                'target_type' => 'quizzes_passed',
                'target_value' => 10,
                'reward_points' => 1000,
                'reward_xp' => 500,
                'reward_gems' => 100,
                'badge_id' => null,
                'is_active' => true,
                'auto_assign' => false,
                'sort_order' => 11,
            ],
            [
                'name' => 'أسبوع الكمال',
                'slug' => 'perfect-week',
                'description' => 'احصل على 5 درجات كاملة هذا الأسبوع',
                'type' => 'weekly',
                'difficulty' => 'hard',
                'icon' => '⭐',
                'target_type' => 'perfect_scores',
                'target_value' => 5,
                'reward_points' => 1500,
                'reward_xp' => 750,
                'reward_gems' => 150,
                'badge_id' => null,
                'is_active' => true,
                'auto_assign' => false,
                'sort_order' => 12,
            ],
            [
                'name' => 'السلسلة المثالية',
                'slug' => 'perfect-streak-weekly',
                'description' => 'سجل دخول يومي لمدة 7 أيام متتالية',
                'type' => 'weekly',
                'difficulty' => 'medium',
                'icon' => '🔥',
                'target_type' => 'login_streak',
                'target_value' => 7,
                'reward_points' => 500,
                'reward_xp' => 250,
                'reward_gems' => 50,
                'badge_id' => null,
                'is_active' => true,
                'auto_assign' => true,
                'sort_order' => 13,
            ],
            [
                'name' => 'جامع النقاط الأسبوعي',
                'slug' => 'point-collector-weekly',
                'description' => 'اكسب 3000 نقطة هذا الأسبوع',
                'type' => 'weekly',
                'difficulty' => 'hard',
                'icon' => '💎',
                'target_type' => 'points_earned',
                'target_value' => 3000,
                'reward_points' => 500,
                'reward_xp' => 250,
                'reward_gems' => 50,
                'badge_id' => null,
                'is_active' => true,
                'auto_assign' => false,
                'sort_order' => 14,
            ],

            // ========================================
            // Monthly Challenges (تحديات شهرية)
            // ========================================
            [
                'name' => 'البطل الشهري',
                'slug' => 'monthly-champion',
                'description' => 'أكمل 100 درس هذا الشهر',
                'type' => 'monthly',
                'difficulty' => 'hard',
                'icon' => '👑',
                'target_type' => 'lessons_completed',
                'target_value' => 100,
                'reward_points' => 5000,
                'reward_xp' => 2500,
                'reward_gems' => 500,
                'badge_id' => null,
                'is_active' => true,
                'auto_assign' => false,
                'sort_order' => 20,
            ],
            [
                'name' => 'منهي الكورسات',
                'slug' => 'course-finisher-monthly',
                'description' => 'أكمل 3 كورسات هذا الشهر',
                'type' => 'monthly',
                'difficulty' => 'hard',
                'icon' => '🎯',
                'target_type' => 'courses_completed',
                'target_value' => 3,
                'reward_points' => 8000,
                'reward_xp' => 4000,
                'reward_gems' => 800,
                'badge_id' => null,
                'is_active' => true,
                'auto_assign' => false,
                'sort_order' => 21,
            ],
            [
                'name' => 'ملك الاختبارات',
                'slug' => 'quiz-king-monthly',
                'description' => 'اجتز 50 اختباراً هذا الشهر',
                'type' => 'monthly',
                'difficulty' => 'hard',
                'icon' => '🏅',
                'target_type' => 'quizzes_passed',
                'target_value' => 50,
                'reward_points' => 6000,
                'reward_xp' => 3000,
                'reward_gems' => 600,
                'badge_id' => null,
                'is_active' => true,
                'auto_assign' => false,
                'sort_order' => 22,
            ],
            [
                'name' => 'الشهر الكامل',
                'slug' => 'full-month-streak',
                'description' => 'سجل دخول يومي طوال الشهر (30 يوم)',
                'type' => 'monthly',
                'difficulty' => 'hard',
                'icon' => '🌟',
                'target_type' => 'login_streak',
                'target_value' => 30,
                'reward_points' => 3000,
                'reward_xp' => 1500,
                'reward_gems' => 300,
                'badge_id' => null,
                'is_active' => true,
                'auto_assign' => false,
                'sort_order' => 23,
            ],
            [
                'name' => 'المليونير الشهري',
                'slug' => 'monthly-millionaire',
                'description' => 'اكسب 10,000 نقطة هذا الشهر',
                'type' => 'monthly',
                'difficulty' => 'hard',
                'icon' => '💰',
                'target_type' => 'points_earned',
                'target_value' => 10000,
                'reward_points' => 2000,
                'reward_xp' => 1000,
                'reward_gems' => 200,
                'badge_id' => null,
                'is_active' => true,
                'auto_assign' => false,
                'sort_order' => 24,
            ],

            // ========================================
            // Special Challenges (تحديات خاصة)
            // ========================================
            [
                'name' => 'صائد الشارات',
                'slug' => 'badge-hunter-challenge',
                'description' => 'اكسب 10 شارات جديدة',
                'type' => 'special',
                'difficulty' => 'hard',
                'icon' => '🎖️',
                'target_type' => 'badges_earned',
                'target_value' => 10,
                'reward_points' => 2000,
                'reward_xp' => 1000,
                'reward_gems' => 200,
                'badge_id' => null,
                'is_active' => true,
                'auto_assign' => false,
                'sort_order' => 30,
            ],
            [
                'name' => 'صاحب الإنجازات',
                'slug' => 'achievement-master',
                'description' => 'أكمل 5 إنجازات',
                'type' => 'special',
                'difficulty' => 'hard',
                'icon' => '🏆',
                'target_type' => 'achievements_completed',
                'target_value' => 5,
                'reward_points' => 2500,
                'reward_xp' => 1250,
                'reward_gems' => 250,
                'badge_id' => null,
                'is_active' => true,
                'auto_assign' => false,
                'sort_order' => 31,
            ],
            [
                'name' => 'المتعلم السريع',
                'slug' => 'speed-learner-challenge',
                'description' => 'أكمل كورساً كاملاً في 3 أيام',
                'type' => 'special',
                'difficulty' => 'hard',
                'icon' => '⚡',
                'target_type' => 'courses_completed',
                'target_value' => 1,
                'reward_points' => 1500,
                'reward_xp' => 750,
                'reward_gems' => 150,
                'badge_id' => null,
                'is_active' => true,
                'auto_assign' => false,
                'sort_order' => 32,
            ],
        ];

        foreach ($challenges as $challenge) {
            Challenge::updateOrCreate(
                ['slug' => $challenge['slug']],
                $challenge
            );
        }

        $this->command->info('✅ تم إنشاء ' . count($challenges) . ' تحدي بنجاح!');
    }
}
