<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\FrontendCourse;
use App\Models\FrontendCourseCategory;
use App\Models\User;

class FrontendCoursesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Truncate existing courses
        \DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        FrontendCourse::truncate();
        \DB::statement('SET FOREIGN_KEY_CHECKS=1;');

        $webDev = FrontendCourseCategory::where('slug', 'web-development')->first();
        $mobileDev = FrontendCourseCategory::where('slug', 'mobile-development')->first();
        $python = FrontendCourseCategory::where('slug', 'python-programming')->first();
        $design = FrontendCourseCategory::where('slug', 'graphic-design')->first();
        $dataAnalysis = FrontendCourseCategory::where('slug', 'data-analysis')->first();
        $marketing = FrontendCourseCategory::where('slug', 'digital-marketing')->first();
        $ai = FrontendCourseCategory::where('slug', 'artificial-intelligence')->first();
        $security = FrontendCourseCategory::where('slug', 'cybersecurity')->first();

        // Get any user as instructor
        $instructor = User::first();

        if (!$instructor) {
            $this->command->error('No users found in database. Please create at least one user first.');
            return;
        }

        $courses = [
            // Web Development Courses
            [
                'title' => 'تطوير تطبيقات الويب بـ Laravel',
                'slug' => 'laravel-web-development',
                'subtitle' => 'من الصفر إلى الاحتراف',
                'description' => 'كورس شامل لتعلم إطار العمل Laravel من البداية حتى بناء تطبيقات ويب احترافية كاملة',
                'category_id' => $webDev->id,
                'instructor_id' => $instructor->id,
                'what_you_learn' => [
                    'أساسيات Laravel وبنية MVC',
                    'بناء RESTful APIs',
                    'العمل مع قواعد البيانات Eloquent ORM',
                    'Authentication و Authorization',
                    'إدارة الملفات والصور',
                    'نشر التطبيقات على الخوادم',
                ],
                'requirements' => 'معرفة أساسية بـ PHP و HTML و CSS',
                'level' => 'intermediate',
                'language' => 'ar',
                'duration' => 45.5,
                'lessons_count' => 120,
                'price' => 499.00,
                'discount_price' => 399.00,
                'is_free' => false,
                'currency' => 'SAR',
                'status' => 'published',
                'is_featured' => true,
                'is_active' => true,
                'published_at' => now(),
                'students_count' => 1250,
                'rating' => 4.8,
                'reviews_count' => 320,
                'views_count' => 5600,
                'certificate' => true,
                'lifetime_access' => true,
                'downloadable_resources' => true,
                // Basic SEO
                'meta_title' => 'كورس Laravel - تطوير تطبيقات الويب من الصفر حتى الاحتراف',
                'meta_description' => 'تعلم Laravel من الصفر حتى الاحتراف مع مشاريع عملية. كورس شامل يغطي MVC, APIs, Eloquent, Authentication والمزيد. سجل الآن!',
                'meta_keywords' => 'Laravel, تطوير ويب, PHP, MVC, API, Eloquent, كورس Laravel, تعلم Laravel',
                // Open Graph
                'og_title' => 'كورس Laravel - تطوير تطبيقات الويب الاحترافية',
                'og_description' => 'كورس شامل لتعلم Laravel من الصفر حتى بناء تطبيقات ويب احترافية. 120 درس، 45 ساعة، شهادة معتمدة.',
                'og_type' => 'course',
                // Twitter Card
                'twitter_card' => 'summary_large_image',
                'twitter_title' => 'كورس Laravel - من الصفر للاحتراف',
                'twitter_description' => 'تعلم بناء تطبيقات ويب احترافية باستخدام Laravel. 1250+ طالب، تقييم 4.8 نجوم.',
                // Advanced SEO
                'canonical_url' => url('/courses/laravel-web-development'),
                'robots' => 'index, follow',
                'author' => 'فريق المنصة التعليمية',
                'focus_keyword' => 'Laravel',
                'reading_time' => 12,
                'order' => 1,
            ],
            [
                'title' => 'بناء واجهات تفاعلية بـ Vue.js',
                'slug' => 'vuejs-interactive-interfaces',
                'subtitle' => 'إطار العمل الأقوى لبناء الواجهات',
                'description' => 'تعلم Vue.js 3 وبناء تطبيقات ويب تفاعلية حديثة باستخدام Composition API',
                'category_id' => $webDev->id,
                'instructor_id' => $instructor->id,
                'what_you_learn' => [
                    'أساسيات Vue.js 3',
                    'Composition API',
                    'إدارة الحالة بـ Pinia',
                    'Vue Router للتنقل',
                    'التكامل مع APIs',
                    'بناء مكونات قابلة لإعادة الاستخدام',
                ],
                'requirements' => 'معرفة جيدة بـ JavaScript و HTML و CSS',
                'level' => 'intermediate',
                'language' => 'ar',
                'duration' => 32.0,
                'lessons_count' => 85,
                'price' => 399.00,
                'discount_price' => 299.00,
                'is_free' => false,
                'currency' => 'SAR',
                'status' => 'published',
                'is_featured' => true,
                'is_active' => true,
                'published_at' => now(),
                'students_count' => 890,
                'rating' => 4.7,
                'reviews_count' => 215,
                'views_count' => 3200,
                'certificate' => true,
                'lifetime_access' => true,
                'order' => 2,
            ],
            [
                'title' => 'تطوير مواقع ووردبريس احترافية',
                'slug' => 'wordpress-professional-development',
                'subtitle' => 'من التنصيب حتى التطوير المتقدم',
                'description' => 'دليلك الشامل لتطوير مواقع ووردبريس احترافية وبناء قوالب ومكونات إضافية',
                'category_id' => $webDev->id,
                'instructor_id' => $instructor->id,
                'what_you_learn' => [
                    'إعداد بيئة العمل',
                    'بناء القوالب من الصفر',
                    'تطوير المكونات الإضافية',
                    'تخصيص لوحة التحكم',
                    'تحسين الأداء والأمان',
                    'SEO وتحسين محركات البحث',
                ],
                'requirements' => 'معرفة أساسية بـ PHP و HTML و CSS',
                'level' => 'beginner',
                'language' => 'ar',
                'duration' => 28.5,
                'lessons_count' => 75,
                'price' => 0,
                'discount_price' => null,
                'is_free' => true,
                'currency' => 'SAR',
                'status' => 'published',
                'is_featured' => true,
                'is_active' => true,
                'published_at' => now(),
                'students_count' => 2340,
                'rating' => 4.6,
                'reviews_count' => 450,
                'views_count' => 8900,
                'certificate' => true,
                'lifetime_access' => true,
                'order' => 3,
            ],

            // Mobile Development Courses
            [
                'title' => 'تطوير تطبيقات Android بـ Kotlin',
                'slug' => 'android-development-kotlin',
                'subtitle' => 'بناء تطبيقات أندرويد احترافية',
                'description' => 'تعلم تطوير تطبيقات Android الحديثة باستخدام لغة Kotlin و Jetpack Compose',
                'category_id' => $mobileDev->id,
                'instructor_id' => $instructor->id,
                'what_you_learn' => [
                    'أساسيات لغة Kotlin',
                    'Android Studio والأدوات',
                    'Jetpack Compose للواجهات',
                    'الاتصال بـ APIs',
                    'قواعد البيانات المحلية',
                    'نشر التطبيقات على Google Play',
                ],
                'requirements' => 'معرفة أساسية بالبرمجة',
                'level' => 'intermediate',
                'language' => 'ar',
                'duration' => 52.0,
                'lessons_count' => 140,
                'price' => 599.00,
                'discount_price' => 449.00,
                'is_free' => false,
                'currency' => 'SAR',
                'status' => 'published',
                'is_featured' => true,
                'is_active' => true,
                'published_at' => now(),
                'students_count' => 780,
                'rating' => 4.9,
                'reviews_count' => 189,
                'views_count' => 4100,
                'certificate' => true,
                'lifetime_access' => true,
                'downloadable_resources' => true,
                'order' => 4,
            ],
            [
                'title' => 'Flutter للمبتدئين',
                'slug' => 'flutter-for-beginners',
                'subtitle' => 'طوّر تطبيقات iOS و Android بكود واحد',
                'description' => 'ابدأ رحلتك في تطوير تطبيقات الجوال باستخدام Flutter و Dart',
                'category_id' => $mobileDev->id,
                'instructor_id' => $instructor->id,
                'what_you_learn' => [
                    'أساسيات لغة Dart',
                    'بناء الواجهات بـ Widgets',
                    'إدارة الحالة',
                    'التعامل مع Firebase',
                    'النشر على المتاجر',
                ],
                'requirements' => 'لا يوجد - مناسب للمبتدئين',
                'level' => 'beginner',
                'language' => 'ar',
                'duration' => 38.0,
                'lessons_count' => 95,
                'price' => 0,
                'discount_price' => null,
                'is_free' => true,
                'currency' => 'SAR',
                'status' => 'published',
                'is_featured' => true,
                'is_active' => true,
                'published_at' => now(),
                'students_count' => 1560,
                'rating' => 4.7,
                'reviews_count' => 298,
                'views_count' => 6700,
                'certificate' => true,
                'lifetime_access' => true,
                'order' => 5,
            ],

            // Python Programming Courses
            [
                'title' => 'Python من الصفر للاحتراف',
                'slug' => 'python-zero-to-hero',
                'subtitle' => 'الدليل الشامل لتعلم Python',
                'description' => 'تعلم لغة Python من البداية حتى المستوى المتقدم مع مشاريع عملية',
                'category_id' => $python->id,
                'instructor_id' => $instructor->id,
                'what_you_learn' => [
                    'أساسيات Python',
                    'البرمجة الكائنية OOP',
                    'التعامل مع الملفات وقواعد البيانات',
                    'المكتبات الشهيرة',
                    'بناء مشاريع حقيقية',
                    'أفضل الممارسات',
                ],
                'requirements' => 'لا يوجد - للمبتدئين',
                'level' => 'beginner',
                'language' => 'ar',
                'duration' => 42.0,
                'lessons_count' => 110,
                'price' => 449.00,
                'discount_price' => 349.00,
                'is_free' => false,
                'currency' => 'SAR',
                'status' => 'published',
                'is_featured' => true,
                'is_active' => true,
                'published_at' => now(),
                'students_count' => 3200,
                'rating' => 4.9,
                'reviews_count' => 678,
                'views_count' => 12500,
                'certificate' => true,
                'lifetime_access' => true,
                'downloadable_resources' => true,
                'order' => 6,
            ],
            [
                'title' => 'Django: بناء تطبيقات ويب بايثون',
                'slug' => 'django-web-applications',
                'subtitle' => 'إطار العمل الأشهر لـ Python',
                'description' => 'احترف بناء تطبيقات الويب القوية والآمنة باستخدام Django',
                'category_id' => $python->id,
                'instructor_id' => $instructor->id,
                'what_you_learn' => [
                    'بنية Django الأساسية',
                    'Models و ORM',
                    'Views و Templates',
                    'Forms و Validation',
                    'Authentication',
                    'REST APIs مع Django REST Framework',
                ],
                'requirements' => 'معرفة أساسية بـ Python',
                'level' => 'intermediate',
                'language' => 'ar',
                'duration' => 36.5,
                'lessons_count' => 92,
                'price' => 499.00,
                'discount_price' => null,
                'is_free' => false,
                'currency' => 'SAR',
                'status' => 'published',
                'is_featured' => false,
                'is_active' => true,
                'published_at' => now(),
                'students_count' => 650,
                'rating' => 4.6,
                'reviews_count' => 142,
                'views_count' => 2800,
                'certificate' => true,
                'lifetime_access' => true,
                'order' => 7,
            ],

            // Graphic Design Courses
            [
                'title' => 'Adobe Photoshop للمحترفين',
                'slug' => 'adobe-photoshop-professional',
                'subtitle' => 'إتقان فوتوشوب من الألف للياء',
                'description' => 'دورة شاملة لتعلم Adobe Photoshop واحتراف تحرير الصور والتصميم الجرافيكي',
                'category_id' => $design->id,
                'instructor_id' => $instructor->id,
                'what_you_learn' => [
                    'واجهة البرنامج والأدوات',
                    'تحرير ومعالجة الصور',
                    'الطبقات والماسكات',
                    'التأثيرات والفلاتر',
                    'تصميم السوشيال ميديا',
                    'الطباعة والإخراج',
                ],
                'requirements' => 'لا يوجد',
                'level' => 'beginner',
                'language' => 'ar',
                'duration' => 30.0,
                'lessons_count' => 78,
                'price' => 349.00,
                'discount_price' => 249.00,
                'is_free' => false,
                'currency' => 'SAR',
                'status' => 'published',
                'is_featured' => false,
                'is_active' => true,
                'published_at' => now(),
                'students_count' => 1420,
                'rating' => 4.8,
                'reviews_count' => 356,
                'views_count' => 5200,
                'certificate' => true,
                'lifetime_access' => true,
                'order' => 8,
            ],
            [
                'title' => 'تصميم الهوية البصرية الكاملة',
                'slug' => 'brand-identity-design',
                'subtitle' => 'من الفكرة إلى التنفيذ',
                'description' => 'تعلم تصميم هويات بصرية احترافية ومتكاملة للشركات والمشاريع',
                'category_id' => $design->id,
                'instructor_id' => $instructor->id,
                'what_you_learn' => [
                    'أساسيات الهوية البصرية',
                    'تصميم الشعارات',
                    'اختيار الألوان والخطوط',
                    'بناء Brand Guidelines',
                    'تصميم المطبوعات',
                    'التطبيق على منصات مختلفة',
                ],
                'requirements' => 'معرفة أساسية ببرامج التصميم',
                'level' => 'intermediate',
                'language' => 'ar',
                'duration' => 25.0,
                'lessons_count' => 62,
                'price' => 0,
                'discount_price' => null,
                'is_free' => true,
                'currency' => 'SAR',
                'status' => 'published',
                'is_featured' => true,
                'is_active' => true,
                'published_at' => now(),
                'students_count' => 980,
                'rating' => 4.7,
                'reviews_count' => 201,
                'views_count' => 4300,
                'certificate' => true,
                'lifetime_access' => true,
                'order' => 9,
            ],

            // Data Analysis Courses
            [
                'title' => 'تحليل البيانات بـ Python',
                'slug' => 'data-analysis-python',
                'subtitle' => 'Pandas, NumPy, و Matplotlib',
                'description' => 'احترف تحليل البيانات واستخراج الرؤى باستخدام مكتبات Python القوية',
                'category_id' => $dataAnalysis->id,
                'instructor_id' => $instructor->id,
                'what_you_learn' => [
                    'أساسيات تحليل البيانات',
                    'مكتبة Pandas للمعالجة',
                    'NumPy للحسابات',
                    'تصور البيانات بـ Matplotlib',
                    'Seaborn للرسومات المتقدمة',
                    'مشاريع تحليل حقيقية',
                ],
                'requirements' => 'معرفة أساسية بـ Python',
                'level' => 'intermediate',
                'language' => 'ar',
                'duration' => 40.0,
                'lessons_count' => 105,
                'price' => 549.00,
                'discount_price' => 449.00,
                'is_free' => false,
                'currency' => 'SAR',
                'status' => 'published',
                'is_featured' => true,
                'is_active' => true,
                'published_at' => now(),
                'students_count' => 1120,
                'rating' => 4.8,
                'reviews_count' => 267,
                'views_count' => 4900,
                'certificate' => true,
                'lifetime_access' => true,
                'downloadable_resources' => true,
                'order' => 10,
            ],

            // Digital Marketing Courses
            [
                'title' => 'التسويق عبر وسائل التواصل الاجتماعي',
                'slug' => 'social-media-marketing',
                'subtitle' => 'استراتيجيات النمو السريع',
                'description' => 'تعلم التسويق الفعال على منصات السوشيال ميديا وبناء حضور قوي لعلامتك',
                'category_id' => $marketing->id,
                'instructor_id' => $instructor->id,
                'what_you_learn' => [
                    'استراتيجيات المحتوى',
                    'الإعلانات المدفوعة',
                    'تحليل البيانات والنتائج',
                    'بناء المجتمعات',
                    'أدوات الجدولة والإدارة',
                    'دراسات حالة واقعية',
                ],
                'requirements' => 'لا يوجد',
                'level' => 'beginner',
                'language' => 'ar',
                'duration' => 22.0,
                'lessons_count' => 58,
                'price' => 299.00,
                'discount_price' => 199.00,
                'is_free' => false,
                'currency' => 'SAR',
                'status' => 'published',
                'is_featured' => false,
                'is_active' => true,
                'published_at' => now(),
                'students_count' => 1890,
                'rating' => 4.6,
                'reviews_count' => 412,
                'views_count' => 7200,
                'certificate' => true,
                'lifetime_access' => true,
                'order' => 11,
            ],

            // AI Courses
            [
                'title' => 'مقدمة في التعلم الآلي Machine Learning',
                'slug' => 'machine-learning-introduction',
                'subtitle' => 'ابدأ رحلتك في الذكاء الاصطناعي',
                'description' => 'تعلم أساسيات التعلم الآلي وبناء نماذج ذكية باستخدام Python',
                'category_id' => $ai->id,
                'instructor_id' => $instructor->id,
                'what_you_learn' => [
                    'مفاهيم التعلم الآلي',
                    'Scikit-learn',
                    'خوارزميات التصنيف',
                    'خوارزميات الانحدار',
                    'تقييم النماذج',
                    'مشاريع عملية',
                ],
                'requirements' => 'معرفة بـ Python وأساسيات الرياضيات',
                'level' => 'intermediate',
                'language' => 'ar',
                'duration' => 48.0,
                'lessons_count' => 125,
                'price' => 649.00,
                'discount_price' => 499.00,
                'is_free' => false,
                'currency' => 'SAR',
                'status' => 'published',
                'is_featured' => true,
                'is_active' => true,
                'published_at' => now(),
                'students_count' => 920,
                'rating' => 4.9,
                'reviews_count' => 234,
                'views_count' => 5800,
                'certificate' => true,
                'lifetime_access' => true,
                'downloadable_resources' => true,
                'order' => 12,
            ],

            // Cybersecurity Courses
            [
                'title' => 'أساسيات الأمن السيبراني',
                'slug' => 'cybersecurity-fundamentals',
                'subtitle' => 'احمِ نفسك ومؤسستك',
                'description' => 'تعلم مبادئ الأمن السيبراني وحماية الأنظمة من الهجمات الإلكترونية',
                'category_id' => $security->id,
                'instructor_id' => $instructor->id,
                'what_you_learn' => [
                    'مفاهيم الأمن الأساسية',
                    'أنواع الهجمات الشائعة',
                    'التشفير وحماية البيانات',
                    'أمن الشبكات',
                    'الاختبار الأمني',
                    'أدوات الحماية',
                ],
                'requirements' => 'معرفة أساسية بالشبكات',
                'level' => 'beginner',
                'language' => 'ar',
                'duration' => 35.0,
                'lessons_count' => 88,
                'price' => 0,
                'discount_price' => null,
                'is_free' => true,
                'currency' => 'SAR',
                'status' => 'published',
                'is_featured' => false,
                'is_active' => true,
                'published_at' => now(),
                'students_count' => 1560,
                'rating' => 4.7,
                'reviews_count' => 298,
                'views_count' => 6100,
                'certificate' => true,
                'lifetime_access' => true,
                'order' => 13,
            ],
        ];

        foreach ($courses as $course) {
            FrontendCourse::create($course);
        }
    }
}
