@extends('admin.layouts.master')

@section('page-title')
    تعديل لوحة المتصدرين
@stop

@section('content')
    <div class="main-content app-content">
        <div class="container-fluid">
            <div class="d-md-flex d-block align-items-center justify-content-between my-4 page-header-breadcrumb"></div>

            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>@foreach ($errors->all() as $error)<li>{{ $error }}</li>@endforeach</ul>
                </div>
            @endif

            <div class="row">
                <div class="col-xl-12">
                    <div class="card shadow-sm border-0">
                        <div class="card-header d-flex justify-content-between align-items-center bg-light">
                            <h5 class="mb-0 fw-bold">تعديل لوحة المتصدرين: {{ $leaderboard->name }}</h5>
                            <a class="btn btn-sm btn-secondary" href="{{ route('admin.gamification.leaderboards.index') }}">
                                <i class="fas fa-arrow-right me-1"></i> رجوع
                            </a>
                        </div>
                        <div class="card-body">
                            <form action="{{ route('admin.gamification.leaderboards.update', $leaderboard->id) }}" method="POST">
                                @csrf
                                @method('PUT')
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">الاسم <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" name="name" value="{{ old('name', $leaderboard->name) }}" required>
                                    </div>
                                    <div class="col-md-3 mb-3">
                                        <label class="form-label">النوع</label>
                                        <select class="form-select" name="type">
                                            <option value="points" {{ $leaderboard->type == 'points' ? 'selected' : '' }}>النقاط</option>
                                            <option value="xp" {{ $leaderboard->type == 'xp' ? 'selected' : '' }}>XP</option>
                                            <option value="badges" {{ $leaderboard->type == 'badges' ? 'selected' : '' }}>الشارات</option>
                                            <option value="streak" {{ $leaderboard->type == 'streak' ? 'selected' : '' }}>السلسلة</option>
                                        </select>
                                    </div>
                                    <div class="col-md-3 mb-3">
                                        <label class="form-label">الفترة</label>
                                        <select class="form-select" name="period">
                                            <option value="daily" {{ $leaderboard->period == 'daily' ? 'selected' : '' }}>يومي</option>
                                            <option value="weekly" {{ $leaderboard->period == 'weekly' ? 'selected' : '' }}>أسبوعي</option>
                                            <option value="monthly" {{ $leaderboard->period == 'monthly' ? 'selected' : '' }}>شهري</option>
                                            <option value="all_time" {{ $leaderboard->period == 'all_time' ? 'selected' : '' }}>كل الأوقات</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">الوصف</label>
                                    <textarea class="form-control" name="description" rows="3">{{ old('description', $leaderboard->description) }}</textarea>
                                </div>
                                <div class="mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" name="is_active" value="1" {{ $leaderboard->is_active ? 'checked' : '' }}>
                                        <label class="form-check-label">نشط</label>
                                    </div>
                                </div>
                                <div class="d-flex justify-content-end">
                                    <button type="submit" class="btn btn-primary"><i class="fas fa-save me-1"></i> تحديث</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@stop
