@extends('admin.layouts.master')

@section('page-title')
    تقرير رفع المستخدمين
@stop

@section('css')
    <style>
        .stats-card {
            padding: 30px;
            border-radius: 10px;
            text-align: center;
            margin-bottom: 20px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        }
        .stats-number {
            font-size: 3em;
            font-weight: bold;
            margin-bottom: 10px;
        }
        .stats-label {
            font-size: 1.1em;
            color: #6c757d;
        }
        .success-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 30px;
            border-radius: 10px 10px 0 0;
        }
        .table-section {
            margin-top: 30px;
        }
        .badge-field {
            margin: 2px;
        }
        .download-section {
            background: #f8f9fa;
            padding: 20px;
            border-radius: 5px;
            margin-top: 20px;
        }
    </style>
@stop

@section('content')
    <div class="main-content app-content mt-0">
        <div class="side-app">
            <div class="main-container container-fluid">

                <!-- Page Header -->
                <div class="page-header">
                    <h1 class="page-title">تقرير رفع المستخدمين</h1>
                    <div>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">الرئيسية</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('users.index') }}">المستخدمون</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('users.bulk-import.index') }}">رفع جماعي</a></li>
                            <li class="breadcrumb-item active" aria-current="page">التقرير</li>
                        </ol>
                    </div>
                </div>

                @if(session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="fa fa-check-circle me-2"></i>
                        <strong>{{ session('success') }}</strong>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif

                @if(session('error'))
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <i class="fa fa-exclamation-circle me-2"></i>
                        <strong>{{ session('error') }}</strong>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif

                <!-- Success Summary -->
                <div class="card">
                    <div class="success-header text-center">
                        <i class="fa fa-check-circle fa-3x mb-3"></i>
                        <h2>تم الانتهاء من عملية الرفع!</h2>
                        <p class="mb-0">تم معالجة {{ $session->total_rows }} صف من الملف</p>
                    </div>
                    <div class="card-body">
                        <!-- Statistics Cards -->
                        <div class="row">
                            <div class="col-md-3">
                                <div class="stats-card bg-primary-transparent">
                                    <div class="stats-number text-primary">{{ $session->new_users }}</div>
                                    <div class="stats-label">طلاب جدد</div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="stats-card bg-warning-transparent">
                                    <div class="stats-number text-warning">{{ $session->updated_users }}</div>
                                    <div class="stats-label">تم تحديثهم</div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="stats-card bg-info-transparent">
                                    <div class="stats-number text-info">{{ $session->enrollments_created }}</div>
                                    <div class="stats-label">تسجيلات في كورسات</div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="stats-card bg-danger-transparent">
                                    <div class="stats-number text-danger">{{ $session->failed_rows }}</div>
                                    <div class="stats-label">أخطاء</div>
                                </div>
                            </div>
                        </div>

                        <!-- Additional Stats -->
                        <div class="row mt-4">
                            <div class="col-md-6">
                                <div class="stats-card bg-success-transparent">
                                    <div class="stats-number text-success">{{ $session->group_members_added }}</div>
                                    <div class="stats-label">إضافات للمجموعات</div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="stats-card bg-secondary-transparent">
                                    <div class="stats-number text-secondary">{{ $session->skipped_rows }}</div>
                                    <div class="stats-label">صفوف متخطاة</div>
                                </div>
                            </div>
                        </div>

                        <!-- Success Rate -->
                        <div class="progress mt-4" style="height: 30px;">
                            <div class="progress-bar bg-success" role="progressbar"
                                 style="width: {{ $session->getSuccessRate() }}%"
                                 aria-valuenow="{{ $session->getSuccessRate() }}" aria-valuemin="0" aria-valuemax="100">
                                معدل النجاح: {{ $session->getSuccessRate() }}%
                            </div>
                        </div>
                    </div>
                </div>

                <!-- New Users Table -->
                @if($session->new_users > 0)
                    <div class="card table-section">
                        <div class="card-header bg-primary-transparent">
                            <h3 class="card-title">
                                <i class="fa fa-user-plus me-2"></i>
                                الطلاب الجدد ({{ $session->new_users }})
                            </h3>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-hover table-striped">
                                    <thead class="table-primary">
                                        <tr>
                                            <th width="50">#</th>
                                            <th>الاسم</th>
                                            <th>البريد الإلكتروني</th>
                                            <th>الكورس</th>
                                            <th>المجموعة</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($session->new_users_details as $index => $user)
                                            <tr>
                                                <td>{{ $index + 1 }}</td>
                                                <td>
                                                    <i class="fa fa-user text-success me-1"></i>
                                                    {{ $user['name'] }}
                                                </td>
                                                <td>{{ $user['email'] }}</td>
                                                <td>
                                                    @if(!empty($user['course']))
                                                        <span class="badge bg-info">{{ $user['course'] }}</span>
                                                    @else
                                                        <span class="text-muted">-</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    @if(!empty($user['group']))
                                                        <span class="badge bg-secondary">{{ $user['group'] }}</span>
                                                    @else
                                                        <span class="text-muted">-</span>
                                                    @endif
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                @endif

                <!-- Updated Users Table -->
                @if($session->updated_users > 0)
                    <div class="card table-section">
                        <div class="card-header bg-warning-transparent">
                            <h3 class="card-title">
                                <i class="fa fa-sync-alt me-2"></i>
                                الطلاب الذين تم تحديثهم ({{ $session->updated_users }})
                            </h3>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-hover table-striped">
                                    <thead class="table-warning">
                                        <tr>
                                            <th width="50">#</th>
                                            <th>الاسم</th>
                                            <th>البريد الإلكتروني</th>
                                            <th>البيانات المحدثة</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($session->updated_users_details as $index => $user)
                                            <tr>
                                                <td>{{ $index + 1 }}</td>
                                                <td>
                                                    <i class="fa fa-user-edit text-warning me-1"></i>
                                                    {{ $user['name'] }}
                                                </td>
                                                <td>{{ $user['email'] }}</td>
                                                <td>
                                                    @foreach($user['updated_fields'] as $field)
                                                        <span class="badge bg-info badge-field">{{ $field }}</span>
                                                    @endforeach
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                @endif

                <!-- Errors Table -->
                @if($session->failed_rows > 0)
                    <div class="card table-section">
                        <div class="card-header bg-danger-transparent">
                            <h3 class="card-title">
                                <i class="fa fa-exclamation-triangle me-2"></i>
                                الأخطاء ({{ $session->failed_rows }})
                            </h3>
                        </div>
                        <div class="card-body">
                            <div class="alert alert-warning">
                                <i class="fa fa-info-circle me-2"></i>
                                توجد {{ $session->failed_rows }} صفوف فشل معالجتها. يمكنك تحميل ملف الأخطاء لمراجعتها وتصحيحها.
                            </div>
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead class="table-danger">
                                        <tr>
                                            <th width="80">الصف</th>
                                            <th>البريد</th>
                                            <th>الخطأ</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($session->errors as $error)
                                            <tr>
                                                <td>
                                                    <span class="badge bg-danger">{{ $error['row'] }}</span>
                                                </td>
                                                <td>{{ $error['email'] }}</td>
                                                <td>
                                                    <i class="fa fa-times-circle text-danger me-1"></i>
                                                    {{ $error['message'] }}
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                @endif

                <!-- Download & Actions -->
                <div class="card">
                    <div class="card-body">
                        <div class="download-section">
                            <div class="row align-items-center">
                                <div class="col-md-8">
                                    <h5><i class="fa fa-download me-2"></i>خيارات التحميل والإجراءات</h5>
                                    <p class="text-muted mb-0">قم بتحميل التقارير أو الانتقال إلى قائمة المستخدمين</p>
                                </div>
                                <div class="col-md-4 text-end">
                                    @if($session->failed_rows > 0)
                                        <a href="{{ route('users.bulk-import.errors', $session->id) }}"
                                           class="btn btn-danger mb-2">
                                            <i class="fa fa-file-excel me-2"></i>تحميل ملف الأخطاء
                                        </a>
                                    @endif
                                    <a href="{{ route('users.index') }}" class="btn btn-primary mb-2">
                                        <i class="fa fa-users me-2"></i>عرض المستخدمين
                                    </a>
                                    <a href="{{ route('users.bulk-import.index') }}" class="btn btn-success mb-2">
                                        <i class="fa fa-plus me-2"></i>رفع ملف جديد
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Session Info -->
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">معلومات الجلسة</h3>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <p><strong>رقم الجلسة:</strong> #{{ $session->id }}</p>
                                <p><strong>اسم الملف:</strong> {{ $session->file_name }}</p>
                                <p><strong>الحالة:</strong>
                                    @if($session->isCompleted())
                                        <span class="badge bg-success">مكتمل</span>
                                    @elseif($session->isFailed())
                                        <span class="badge bg-danger">فشل</span>
                                    @elseif($session->isProcessing())
                                        <span class="badge bg-warning">قيد المعالجة</span>
                                    @else
                                        <span class="badge bg-secondary">معلق</span>
                                    @endif
                                </p>
                            </div>
                            <div class="col-md-6">
                                <p><strong>رُفع بواسطة:</strong> {{ $session->uploadedBy->name }}</p>
                                <p><strong>تاريخ البدء:</strong> {{ $session->started_at ? $session->started_at->format('Y-m-d H:i') : '-' }}</p>
                                <p><strong>تاريخ الانتهاء:</strong> {{ $session->completed_at ? $session->completed_at->format('Y-m-d H:i') : '-' }}</p>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
@stop

@section('script')
    <script>
        // Print report
        function printReport() {
            window.print();
        }
    </script>
@stop
