<!-- Toggle User Status Modal -->

<div class="modal fade" id="toggleStatus{{ $user->id }}" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h1 class="modal-title fs-5">تغيير حالة المستخدم</h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form method="POST" action="{{ route('admin.users.toggle-status', $user->id) }}">
                    @csrf
                    <div class="row">
                        @if($user->is_active)
                            <p class="alert alert-warning">
                                <i class="fas fa-exclamation-triangle me-2"></i>
                                هل تريد إيقاف تفعيل المستخدم <strong>{{ $user->name }}</strong>؟
                                <br>
                                <small class="text-muted">سيتم منع المستخدم من الدخول للنظام</small>
                            </p>
                        @else
                            <p class="alert alert-success">
                                <i class="fas fa-check-circle me-2"></i>
                                هل تريد تفعيل المستخدم <strong>{{ $user->name }}</strong>؟
                                <br>
                                <small class="text-muted">سيتمكن المستخدم من الدخول للنظام</small>
                            </p>
                        @endif
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                            <i class="fas fa-times me-1"></i>إلغاء
                        </button>
                        <button type="submit" class="btn {{ $user->is_active ? 'btn-warning' : 'btn-success' }}">
                            <i class="fas fa-power-off me-1"></i>
                            {{ $user->is_active ? 'إيقاف التفعيل' : 'تفعيل' }}
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
