{{-- SEO Meta Tags Component --}}

{{-- Basic Meta Tags --}}
<meta name="description" content="{{ $course->meta_description }}">
<meta name="keywords" content="{{ $course->meta_keywords ?? $course->focus_keyword }}">
<meta name="author" content="{{ $course->author }}">
<meta name="robots" content="{{ $course->robots }}">
@if($course->canonical_url)
<link rel="canonical" href="{{ $course->canonical_url }}">
@endif

{{-- Open Graph (Facebook, LinkedIn) --}}
<meta property="og:title" content="{{ $course->og_title }}">
<meta property="og:description" content="{{ $course->og_description }}">
<meta property="og:image" content="{{ $course->og_image }}">
<meta property="og:type" content="{{ $course->og_type }}">
<meta property="og:url" content="{{ $course->canonical_url }}">
<meta property="og:site_name" content="{{ config('app.name') }}">
<meta property="og:locale" content="ar_SA">

{{-- Twitter Card --}}
<meta name="twitter:card" content="{{ $course->twitter_card }}">
<meta name="twitter:title" content="{{ $course->twitter_title }}">
<meta name="twitter:description" content="{{ $course->twitter_description }}">
<meta name="twitter:image" content="{{ $course->twitter_image }}">
@if(config('services.twitter.username'))
<meta name="twitter:site" content="{{ config('services.twitter.username') }}">
@endif

{{-- Additional SEO --}}
@if($course->reading_time)
<meta name="twitter:label1" content="وقت القراءة">
<meta name="twitter:data1" content="{{ $course->reading_time }} دقيقة">
@endif
@if($course->students_count > 0)
<meta name="twitter:label2" content="عدد الطلاب">
<meta name="twitter:data2" content="{{ number_format($course->students_count) }} طالب">
@endif

{{-- Schema.org JSON-LD Structured Data --}}
<script type="application/ld+json">
{!! json_encode($course->schema_markup ?? $course->generateSchemaMarkup(), JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT) !!}
</script>

{{-- Additional Course-specific Schema --}}
@if($course->reviews_count > 0)
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "Review",
  "itemReviewed": {
    "@type": "Course",
    "name": "{{ $course->title }}"
  },
  "reviewRating": {
    "@type": "Rating",
    "ratingValue": "{{ $course->rating }}",
    "bestRating": "5"
  },
  "author": {
    "@type": "Organization",
    "name": "{{ config('app.name') }}"
  }
}
</script>
@endif

{{-- Breadcrumb Schema --}}
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "BreadcrumbList",
  "itemListElement": [
    {
      "@type": "ListItem",
      "position": 1,
      "name": "الرئيسية",
      "item": "{{ route('frontend.home') }}"
    },
    {
      "@type": "ListItem",
      "position": 2,
      "name": "الكورسات",
      "item": "{{ route('frontend.courses.index') }}"
    },
    {
      "@type": "ListItem",
      "position": 3,
      "name": "{{ $course->category->name ?? 'التصنيف' }}",
      "item": "{{ route('frontend.courses.index', ['category' => $course->category_id]) }}"
    },
    {
      "@type": "ListItem",
      "position": 4,
      "name": "{{ $course->title }}",
      "item": "{{ $course->canonical_url }}"
    }
  ]
}
</script>
