@extends('frontend.layouts.master')

@section('title', $category->meta_title ?: $category->name . ' - المدونة')
@section('meta_description', $category->meta_description ?: 'تصفح مقالات ' . $category->name)
@section('meta_keywords', $category->meta_keywords)

@section('content')

<!-- Page Header -->
<section class="page-header">
    <div class="container">
        <div class="row">
            <div class="col-12 text-center">
                <h1 class="page-title">
                    @if($category->icon)
                    <i class="{{ $category->icon }} me-2"></i>
                    @endif
                    {{ $category->name }}
                </h1>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb justify-content-center">
                        <li class="breadcrumb-item"><a href="{{ route('frontend.home') }}">الرئيسية</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('frontend.blog.index') }}">المدونة</a></li>
                        <li class="breadcrumb-item active">{{ $category->name }}</li>
                    </ol>
                </nav>
                @if($category->description)
                <p class="text-muted mt-3">{{ $category->description }}</p>
                @endif
            </div>
        </div>
    </div>
</section>

<!-- Posts Section -->
<section class="blog-content py-5">
    <div class="container">
        <div class="row">

            <!-- Main Content -->
            <div class="col-lg-8">

                @if($posts->count() > 0)
                <div class="posts-grid">
                    <div class="row g-4">
                        @foreach($posts as $post)
                        <div class="col-md-6">
                            <article class="blog-card">
                                <a href="{{ $post->url }}" class="blog-link">
                                    <!-- Post Image -->
                                    <div class="blog-image">
                                        @if($post->featured_image)
                                            <img src="{{ asset('storage/' . $post->featured_image) }}"
                                                 alt="{{ $post->featured_image_alt ?: $post->title }}">
                                        @else
                                            <div class="blog-image-placeholder">
                                                <i class="fa-solid fa-newspaper"></i>
                                            </div>
                                        @endif

                                        <!-- Reading Time Badge -->
                                        @if($post->reading_time)
                                        <span class="reading-badge">
                                            <i class="fa-solid fa-clock"></i>
                                            {{ $post->reading_time }} دقائق
                                        </span>
                                        @endif

                                        <!-- Category Badge -->
                                        <span class="category-badge" style="background: {{ $category->color ?? 'var(--secondary-Color)' }}">
                                            {{ $category->name }}
                                        </span>
                                    </div>

                                    <!-- Post Content -->
                                    <div class="blog-content">
                                        <h3 class="blog-title">{{ $post->title }}</h3>
                                        <p class="blog-excerpt">{{ Str::limit($post->excerpt, 100) }}</p>

                                        <!-- Post Meta -->
                                        <div class="blog-meta">
                                            <div class="meta-left">
                                                <span class="meta-item">
                                                    <i class="fa-solid fa-user"></i>
                                                    {{ $post->author?->name ?? 'المدير' }}
                                                </span>
                                                <span class="meta-item">
                                                    <i class="fa-solid fa-calendar"></i>
                                                    {{ $post->published_at->diffForHumans() }}
                                                </span>
                                            </div>
                                            <div class="meta-right">
                                                <span class="meta-item">
                                                    <i class="fa-solid fa-eye"></i>
                                                    {{ $post->views_count }}
                                                </span>
                                            </div>
                                        </div>

                                        <!-- Tags -->
                                        @if($post->tags->count() > 0)
                                        <div class="blog-tags">
                                            @foreach($post->tags->take(2) as $tag)
                                            <span class="tag-badge">#{{ $tag->name }}</span>
                                            @endforeach
                                        </div>
                                        @endif

                                        <!-- Read More Button -->
                                        <div class="read-more">
                                            <span class="read-more-text">
                                                اقرأ المزيد
                                                <i class="fa-solid fa-arrow-left"></i>
                                            </span>
                                        </div>
                                    </div>
                                </a>
                            </article>
                        </div>
                        @endforeach
                    </div>

                    <!-- Pagination -->
                    @if($posts->hasPages())
                    <div class="mt-5">
                        {{ $posts->links() }}
                    </div>
                    @endif
                </div>
                @else
                <div class="empty-state text-center py-5">
                    <i class="fa-solid fa-folder-open fa-4x text-muted mb-3"></i>
                    <h4>لا توجد مقالات في هذا التصنيف</h4>
                    <p class="text-muted">سيتم نشر المقالات قريباً</p>
                    <a href="{{ route('frontend.blog.index') }}" class="btn btn-primary mt-3">
                        <i class="fa-solid fa-arrow-right me-2"></i>
                        العودة للمدونة
                    </a>
                </div>
                @endif

            </div>

            <!-- Sidebar -->
            <div class="col-lg-4">
                <aside class="blog-sidebar">

                    <!-- All Categories -->
                    <div class="sidebar-widget">
                        <h4 class="widget-title">
                            <i class="fa-solid fa-folder"></i>
                            جميع التصنيفات
                        </h4>
                        <div class="categories-list">
                            @foreach($allCategories as $cat)
                            <a href="{{ $cat->url }}"
                               class="category-item {{ $cat->id == $category->id ? 'active' : '' }}"
                               style="border-right-color: {{ $cat->color ?? '#007bff' }}">
                                @if($cat->icon)
                                <i class="{{ $cat->icon }} me-2"></i>
                                @endif
                                {{ $cat->name }}
                                <span class="posts-count">{{ $cat->posts_count }}</span>
                            </a>
                            @endforeach
                        </div>
                    </div>

                    <!-- Popular Tags -->
                    @if($popularTags->count() > 0)
                    <div class="sidebar-widget">
                        <h4 class="widget-title">
                            <i class="fa-solid fa-tags"></i>
                            الوسوم الشائعة
                        </h4>
                        <div class="tags-cloud">
                            @foreach($popularTags as $tag)
                            <a href="{{ $tag->url }}"
                               class="tag-cloud-item"
                               style="background-color: {{ $tag->color ?? '#e9ecef' }}">
                                #{{ $tag->name }}
                            </a>
                            @endforeach
                        </div>
                    </div>
                    @endif

                    <!-- Latest Posts -->
                    @if($latestPosts->count() > 0)
                    <div class="sidebar-widget">
                        <h4 class="widget-title">
                            <i class="fa-solid fa-clock"></i>
                            أحدث المقالات
                        </h4>
                        <div class="latest-posts">
                            @foreach($latestPosts as $latest)
                            <a href="{{ $latest->url }}" class="latest-post-item">
                                @if($latest->featured_image)
                                <img src="{{ asset('storage/' . $latest->featured_image) }}"
                                     alt="{{ $latest->title }}">
                                @else
                                <div class="post-placeholder">
                                    <i class="fa-solid fa-file-alt"></i>
                                </div>
                                @endif
                                <div class="post-info">
                                    <h5>{{ Str::limit($latest->title, 50) }}</h5>
                                    <span class="post-date">
                                        <i class="fa-solid fa-calendar"></i>
                                        {{ $latest->published_at->diffForHumans() }}
                                    </span>
                                </div>
                            </a>
                            @endforeach
                        </div>
                    </div>
                    @endif

                </aside>
            </div>

        </div>
    </div>
</section>

@endsection
