@extends('frontend.layouts.master')

@section('title', 'اتصل بنا')
@section('meta_description', 'تواصل معنا - نحن هنا للإجابة على استفساراتك ومساعدتك')

@section('content')

<!-- Page Header -->
<section class="page-header">
    <div class="container">
        <div class="row">
            <div class="col-12 text-center">
                <h1 class="page-title">اتصل بنا</h1>
                <p class="page-subtitle">نحن هنا للإجابة على استفساراتك ومساعدتك</p>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb justify-content-center">
                        <li class="breadcrumb-item"><a href="{{ route('frontend.home') }}">الرئيسية</a></li>
                        <li class="breadcrumb-item active">اتصل بنا</li>
                    </ol>
                </nav>
            </div>
        </div>
    </div>
</section>

<!-- Contact Section -->
<section class="contact-section py-5">
    <div class="container">
        <!-- Contact Info Cards -->
        <div class="row mb-5">
            <div class="col-lg-4 col-md-6 mb-4">
                <div class="contact-info-card">
                    <div class="icon-wrapper">
                        <i class="fa-solid fa-location-dot"></i>
                    </div>
                    <h4>العنوان</h4>
                    <p>المملكة العربية السعودية<br>الرياض - حي النخيل</p>
                </div>
            </div>

            <div class="col-lg-4 col-md-6 mb-4">
                <div class="contact-info-card">
                    <div class="icon-wrapper">
                        <i class="fa-solid fa-phone"></i>
                    </div>
                    <h4>الهاتف</h4>
                    <p dir="ltr">
                        <a href="tel:+966551966588">+966 55 196 6588</a><br>
                        <a href="tel:+966551966588">+966 55 196 6588</a>
                    </p>
                </div>
            </div>

            <div class="col-lg-4 col-md-6 mb-4">
                <div class="contact-info-card">
                    <div class="icon-wrapper">
                        <i class="fa-solid fa-envelope"></i>
                    </div>
                    <h4>البريد الإلكتروني</h4>
                    <p>
                        <a href="mailto:info@claudsoft.com">info@claudsoft.com</a><br>
                        <a href="mailto:support@claudsoft.com">support@claudsoft.com</a>
                    </p>
                </div>
            </div>
        </div>

        <!-- Contact Form & Map -->
        <div class="row">
            <!-- Contact Form -->
            <div class="col-lg-6 mb-4">
                <div class="contact-form-wrapper">
                    <div class="form-header">
                        <h3>أرسل لنا رسالة</h3>
                        <p>املأ النموذج أدناه وسنتواصل معك في أقرب وقت</p>
                    </div>

                    @if(session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="fa-solid fa-check-circle"></i>
                        {{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    @endif

                    @if($errors->any())
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <i class="fa-solid fa-exclamation-circle"></i>
                        <strong>حدث خطأ!</strong> يرجى التحقق من البيانات المدخلة.
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    @endif

                    <form action="{{ route('frontend.contact.send') }}" method="POST" class="contact-form">
                        @csrf

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <div class="form-group">
                                    <label for="name" class="form-label">
                                        <i class="fa-solid fa-user"></i>
                                        الاسم الكامل <span class="required">*</span>
                                    </label>
                                    <input type="text" 
                                           class="form-control @error('name') is-invalid @enderror"
                                           id="name" 
                                           name="name" 
                                           value="{{ old('name') }}"
                                           placeholder="أدخل اسمك الكامل" 
                                           required>
                                    @error('name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6 mb-3">
                                <div class="form-group">
                                    <label for="email" class="form-label">
                                        <i class="fa-solid fa-envelope"></i>
                                        البريد الإلكتروني <span class="required">*</span>
                                    </label>
                                    <input type="email" 
                                           class="form-control @error('email') is-invalid @enderror"
                                           id="email" 
                                           name="email" 
                                           value="{{ old('email') }}"
                                           placeholder="example@email.com" 
                                           required>
                                    @error('email')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <div class="form-group">
                                    <label for="phone" class="form-label">
                                        <i class="fa-solid fa-phone"></i>
                                        رقم الجوال
                                    </label>
                                    <input type="tel" 
                                           class="form-control @error('phone') is-invalid @enderror"
                                           id="phone" 
                                           name="phone" 
                                           value="{{ old('phone') }}"
                                           placeholder="05xxxxxxxx">
                                    @error('phone')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6 mb-3">
                                <div class="form-group">
                                    <label for="subject" class="form-label">
                                        <i class="fa-solid fa-tag"></i>
                                        الموضوع <span class="required">*</span>
                                    </label>
                                    <input type="text" 
                                           class="form-control @error('subject') is-invalid @enderror"
                                           id="subject" 
                                           name="subject" 
                                           value="{{ old('subject') }}"
                                           placeholder="موضوع الرسالة" 
                                           required>
                                    @error('subject')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="form-group mb-4">
                            <label for="message" class="form-label">
                                <i class="fa-solid fa-message"></i>
                                الرسالة <span class="required">*</span>
                            </label>
                            <textarea class="form-control @error('message') is-invalid @enderror"
                                      id="message" 
                                      name="message" 
                                      rows="6"
                                      placeholder="اكتب رسالتك هنا..." 
                                      required>{{ old('message') }}</textarea>
                            @error('message')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <button type="submit" class="btn btn-submit w-100">
                            <i class="fa-solid fa-paper-plane"></i>
                            إرسال الرسالة
                        </button>
                    </form>
                </div>
            </div>

            <!-- Map & Social -->
            <div class="col-lg-6 mb-4">
                <!-- Map -->
                <div class="map-wrapper mb-4">
                    <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3624.564766853959!2d46.67291257603705!3d24.71353557809859!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3e2f03890d489399%3A0xba974d1c98e79fd5!2sRiyadh%20Saudi%20Arabia!5e0!3m2!1sen!2s!4v1698765432109!5m2!1sen!2s"
                            width="100%" 
                            height="350" 
                            style="border:0; border-radius: 10px;" 
                            allowfullscreen="" 
                            loading="lazy"
                            title="موقعنا على الخريطة"></iframe>
                </div>

                <!-- Social Media -->
                <div class="social-media-box">
                    <h4>
                        <i class="fa-solid fa-share-nodes"></i>
                        تابعنا على
                    </h4>
                    <p>كن على اطلاع بأحدث الكورسات والعروض</p>
                    <div class="social-links">
                        <a href="#" class="social-link facebook" target="_blank" rel="noopener noreferrer" title="فيسبوك">
                            <div class="social-icon">
                                <i class="fa-brands fa-facebook-f"></i>
                            </div>
                            <span class="social-text">فيسبوك</span>
                        </a>
                        <a href="#" class="social-link twitter" target="_blank" rel="noopener noreferrer" title="تويتر">
                            <div class="social-icon">
                                <i class="fa-brands fa-x-twitter"></i>
                            </div>
                            <span class="social-text">تويتر</span>
                        </a>
                        <a href="#" class="social-link instagram" target="_blank" rel="noopener noreferrer" title="إنستجرام">
                            <div class="social-icon">
                                <i class="fa-brands fa-instagram"></i>
                            </div>
                            <span class="social-text">إنستجرام</span>
                        </a>
                        <a href="#" class="social-link youtube" target="_blank" rel="noopener noreferrer" title="يوتيوب">
                            <div class="social-icon">
                                <i class="fa-brands fa-youtube"></i>
                            </div>
                            <span class="social-text">يوتيوب</span>
                        </a>
                        <a href="#" class="social-link whatsapp" target="_blank" rel="noopener noreferrer" title="واتساب">
                            <div class="social-icon">
                                <i class="fa-brands fa-whatsapp"></i>
                            </div>
                            <span class="social-text">واتساب</span>
                        </a>
                        <a href="#" class="social-link telegram" target="_blank" rel="noopener noreferrer" title="تيليجرام">
                            <div class="social-icon">
                                <i class="fa-brands fa-telegram"></i>
                            </div>
                            <span class="social-text">تيليجرام</span>
                        </a>
                    </div>
                </div>

                <!-- Working Hours -->
                <div class="working-hours-box mt-4">
                    <h4>
                        <i class="fa-solid fa-clock"></i>
                        ساعات العمل
                    </h4>
                    <ul class="hours-list">
                        <li>
                            <span class="day">السبت - الخميس</span>
                            <span class="time">9:00 ص - 6:00 م</span>
                        </li>
                        <li>
                            <span class="day">الجمعة</span>
                            <span class="time">مغلق</span>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- FAQ Section -->
<section class="faq-section py-5">
    <div class="container">
        <div class="section-header text-center mb-5">
            <h2>الأسئلة الشائعة</h2>
            <p>إجابات سريعة على الأسئلة الأكثر شيوعاً</p>
        </div>

        <div class="row justify-content-center">
            <div class="col-lg-8">
                <div class="accordion" id="faqAccordion">
                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#faq1" aria-expanded="true">
                                كيف يمكنني التسجيل في الكورسات؟
                            </button>
                        </h2>
                        <div id="faq1" class="accordion-collapse collapse show" data-bs-parent="#faqAccordion">
                            <div class="accordion-body">
                                يمكنك التسجيل في الكورسات بكل سهولة من خلال تصفح الكورسات المتاحة، اختيار الكورس المناسب، والضغط على زر "سجل الآن".
                            </div>
                        </div>
                    </div>

                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq2" aria-expanded="false">
                                هل تقدمون شهادات معتمدة؟
                            </button>
                        </h2>
                        <div id="faq2" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                            <div class="accordion-body">
                                نعم، نقدم شهادات إتمام معتمدة لجميع الكورسات بعد إكمال المتطلبات بنجاح.
                            </div>
                        </div>
                    </div>

                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq3" aria-expanded="false">
                                ما هي طرق الدفع المتاحة؟
                            </button>
                        </h2>
                        <div id="faq3" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                            <div class="accordion-body">
                                نوفر عدة طرق للدفع تشمل: البطاقات الائتمانية، التحويل البنكي، وخدمات الدفع الإلكتروني.
                            </div>
                        </div>
                    </div>

                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq4" aria-expanded="false">
                                هل يمكنني الوصول للكورس مدى الحياة؟
                            </button>
                        </h2>
                        <div id="faq4" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                            <div class="accordion-body">
                                نعم، معظم كورساتنا توفر وصول مدى الحياة مع التحديثات المستمرة للمحتوى.
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<style>
/* ============================================
   Page Header - Unified with other pages
   ============================================ */
.page-header {
    background: var(--secondary-Color) !important;
    color: #ffffff !important;
    padding: 80px 0 40px !important;
    margin-bottom: 40px !important;
}

.page-title {
    font-size: 2.5rem !important;
    font-weight: 700 !important;
    margin-bottom: 15px !important;
    color: #ffffff !important;
}

.page-subtitle {
    font-size: 1.2rem;
    color: rgba(255, 255, 255, 0.9);
    margin-bottom: 25px;
}

.page-header .breadcrumb {
    background: transparent;
}

.page-header .breadcrumb-item a {
    color: rgba(255, 255, 255, 0.8);
    text-decoration: none;
    transition: color 0.3s ease;
}

.page-header .breadcrumb-item a:hover {
    color: #ffffff;
}

.page-header .breadcrumb-item.active {
    color: #ffffff;
}

.page-header .breadcrumb-item + .breadcrumb-item::before {
    content: "›";
    color: rgba(255, 255, 255, 0.6);
    margin: 0 10px;
}

/* ============================================
   Contact Section
   ============================================ */
.contact-section {
    background: #f8f9fa;
    min-height: 60vh;
}

/* ============================================
   Contact Info Cards
   ============================================ */
.contact-info-card {
    background: #ffffff;
    padding: 40px 30px;
    border-radius: 15px;
    text-align: center;
    box-shadow: 0 5px 20px rgba(0, 0, 0, 0.08);
    transition: all 0.3s ease;
    height: 100%;
    border: 1px solid #f0f0f0;
}

.contact-info-card:hover {
    transform: translateY(-10px);
    box-shadow: 0 15px 40px rgba(0, 0, 0, 0.15);
    border-color: var(--main-Color);
}

.icon-wrapper {
    width: 80px;
    height: 80px;
    background: var(--main-Color);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 25px;
    transition: all 0.3s ease;
}

.contact-info-card:hover .icon-wrapper {
    background: var(--secondary-Color);
    transform: scale(1.1) rotate(5deg);
}

.icon-wrapper i {
    font-size: 35px;
    color: #ffffff;
}

.contact-info-card h4 {
    font-size: 1.4rem;
    font-weight: 700;
    color: var(--secondary-Color);
    margin-bottom: 15px;
}

.contact-info-card p {
    color: #666;
    line-height: 1.8;
    margin: 0;
}

.contact-info-card a {
    color: var(--main-Color);
    text-decoration: none;
    transition: color 0.3s ease;
    display: inline-block;
}

.contact-info-card a:hover {
    color: var(--secondary-Color);
    text-decoration: underline;
}

/* ============================================
   Contact Form
   ============================================ */
.contact-form-wrapper {
    background: #ffffff;
    padding: 40px;
    border-radius: 15px;
    box-shadow: 0 5px 20px rgba(0, 0, 0, 0.08);
    border: 1px solid #f0f0f0;
}

.form-header {
    margin-bottom: 30px;
    padding-bottom: 20px;
    border-bottom: 2px solid var(--main-Color);
}

.form-header h3 {
    font-size: 1.8rem;
    font-weight: 700;
    color: var(--secondary-Color);
    margin-bottom: 10px;
}

.form-header p {
    color: #666;
    margin: 0;
    font-size: 0.95rem;
}

.form-group {
    margin-bottom: 0;
}

.form-label {
    font-weight: 600;
    color: #2c3e50;
    margin-bottom: 8px;
    display: flex;
    align-items: center;
    gap: 8px;
    font-size: 0.95rem;
}

.form-label i {
    color: var(--main-Color);
    font-size: 14px;
}

.required {
    color: #e74c3c;
    margin-right: 3px;
}

.form-control {
    border: 2px solid #e0e0e0;
    border-radius: 8px;
    padding: 12px 15px;
    transition: all 0.3s ease;
    font-size: 0.95rem;
}

.form-control:focus {
    border-color: var(--main-Color);
    box-shadow: 0 0 0 0.2rem rgba(242, 145, 37, 0.15);
    outline: none;
}

.form-control.is-invalid {
    border-color: #e74c3c;
}

.invalid-feedback {
    font-size: 0.875rem;
    display: block;
    margin-top: 5px;
}

.btn-submit {
    background: var(--main-Color);
    color: #ffffff;
    border: none;
    padding: 15px 40px;
    border-radius: 8px;
    font-size: 1.1rem;
    font-weight: 600;
    transition: all 0.3s ease;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    gap: 10px;
    width: 100%;
}

.btn-submit:hover {
    background: var(--secondary-Color);
    transform: translateY(-2px);
    box-shadow: 0 5px 20px rgba(0, 0, 0, 0.2);
    color: #ffffff;
}

.btn-submit:active {
    transform: translateY(0);
}

/* ============================================
   Alerts
   ============================================ */
.alert {
    border-radius: 8px;
    padding: 15px 20px;
    margin-bottom: 25px;
    display: flex;
    align-items: center;
    gap: 10px;
}

.alert-success {
    background-color: #d4edda;
    border-color: #c3e6cb;
    color: #155724;
}

.alert-danger {
    background-color: #f8d7da;
    border-color: #f5c6cb;
    color: #721c24;
}

.alert i {
    font-size: 1.2rem;
}

/* ============================================
   Map
   ============================================ */
.map-wrapper {
    border-radius: 15px;
    overflow: hidden;
    box-shadow: 0 5px 20px rgba(0, 0, 0, 0.08);
    border: 1px solid #f0f0f0;
}

.map-wrapper iframe {
    display: block;
    width: 100%;
}

/* ============================================
   Social Media Box
   ============================================ */
.social-media-box,
.working-hours-box {
    background: #ffffff;
    padding: 30px;
    border-radius: 15px;
    box-shadow: 0 5px 20px rgba(0, 0, 0, 0.08);
    border: 1px solid #f0f0f0;
}

.social-media-box h4,
.working-hours-box h4 {
    font-size: 1.4rem;
    font-weight: 700;
    color: var(--secondary-Color);
    margin-bottom: 10px;
    display: flex;
    align-items: center;
    gap: 10px;
}

.social-media-box h4 i,
.working-hours-box h4 i {
    color: var(--main-Color);
    font-size: 1.2rem;
}

.social-media-box p {
    color: #666;
    margin-bottom: 20px;
    font-size: 0.95rem;
}

.social-links {
    display: flex;
    flex-direction: column;
    gap: 12px;
}

.social-link {
    display: flex;
    align-items: center;
    justify-content: flex-start;
    gap: 15px;
    padding: 15px 20px;
    border-radius: 12px;
    text-decoration: none;
    color: #ffffff;
    font-weight: 600;
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
}

.social-link::before {
    content: '';
    position: absolute;
    top: 0;
    right: -100%;
    width: 100%;
    height: 100%;
    background: rgba(255, 255, 255, 0.1);
    transition: right 0.3s ease;
}

.social-link:hover::before {
    right: 0;
}

.social-link:hover {
    transform: translateX(-5px) translateY(-2px);
    box-shadow: 0 8px 20px rgba(0, 0, 0, 0.25);
    color: #ffffff;
}

.social-link.facebook { background: linear-gradient(135deg, #3b5998 0%, #2d4373 100%); }
.social-link.twitter { background: linear-gradient(135deg, #1da1f2 0%, #0d8bd9 100%); }
.social-link.instagram { background: linear-gradient(135deg, #E1306C 0%, #C13584 50%, #833AB4 100%); }
.social-link.youtube { background: linear-gradient(135deg, #ff0000 0%, #cc0000 100%); }
.social-link.whatsapp { background: linear-gradient(135deg, #25d366 0%, #128c7e 100%); }
.social-link.telegram { background: linear-gradient(135deg, #0088cc 0%, #006699 100%); }

.social-icon {
    width: 40px;
    height: 40px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: rgba(255, 255, 255, 0.2);
    border-radius: 50%;
    transition: all 0.3s ease;
    flex-shrink: 0;
}

.social-link:hover .social-icon {
    background: rgba(255, 255, 255, 0.3);
    transform: scale(1.1) rotate(5deg);
}

.social-icon i {
    font-size: 20px;
    color: #ffffff;
    display: block;
}

.social-text {
    flex: 1;
    font-size: 1rem;
    font-weight: 600;
}

/* ============================================
   Working Hours
   ============================================ */
.hours-list {
    list-style: none;
    padding: 0;
    margin: 0;
}

.hours-list li {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 15px 0;
    border-bottom: 1px solid #f0f0f0;
}

.hours-list li:last-child {
    border-bottom: none;
}

.day {
    font-weight: 600;
    color: #2c3e50;
}

.time {
    color: var(--main-Color);
    font-weight: 600;
}

/* ============================================
   FAQ Section
   ============================================ */
.faq-section {
    background-color: #f8f9fa;
}

.section-header {
    margin-bottom: 40px;
}

.section-header h2 {
    font-size: 2.5rem;
    font-weight: 700;
    color: var(--secondary-Color);
    margin-bottom: 15px;
}

.section-header p {
    color: #666;
    font-size: 1.1rem;
    margin: 0;
}

.accordion-item {
    border: none;
    margin-bottom: 15px;
    border-radius: 10px !important;
    overflow: hidden;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
    border: 1px solid #f0f0f0;
}

.accordion-button {
    background: #ffffff;
    color: var(--secondary-Color);
    font-weight: 600;
    padding: 20px 25px;
    border: none;
    font-size: 1.1rem;
    box-shadow: none;
}

.accordion-button:not(.collapsed) {
    background: var(--main-Color);
    color: #ffffff;
    box-shadow: none;
}

.accordion-button:focus {
    box-shadow: none;
    border: none;
    outline: none;
}

.accordion-button::after {
    margin-right: auto;
    margin-left: 0;
}

.accordion-body {
    padding: 20px 25px;
    background: #ffffff;
    color: #555;
    line-height: 1.8;
}

/* ============================================
   Responsive Design
   ============================================ */
@media (max-width: 992px) {
    .contact-section {
        padding: 40px 0;
    }
}

@media (max-width: 768px) {
    .page-header {
        padding: 60px 0 30px;
    }

    .page-title {
        font-size: 2rem;
    }

    .page-subtitle {
        font-size: 1rem;
    }

    .contact-form-wrapper {
        padding: 25px 20px;
    }

    .form-header h3 {
        font-size: 1.5rem;
    }

    .contact-info-card {
        margin-bottom: 20px;
        padding: 30px 20px;
    }

    .icon-wrapper {
        width: 70px;
        height: 70px;
    }

    .icon-wrapper i {
        font-size: 28px;
    }

    .section-header h2 {
        font-size: 2rem;
    }

    .social-media-box,
    .working-hours-box {
        padding: 20px;
    }

    .map-wrapper iframe {
        height: 300px;
    }
}

@media (max-width: 576px) {
    .page-title {
        font-size: 1.75rem;
    }

    .contact-info-card h4 {
        font-size: 1.2rem;
    }

    .form-header h3 {
        font-size: 1.3rem;
    }

    .section-header h2 {
        font-size: 1.75rem;
    }

    .accordion-button {
        padding: 15px 20px;
        font-size: 1rem;
    }

    .accordion-body {
        padding: 15px 20px;
    }
}
</style>

@endsection
