<div class="faqs-section py-5">
    <div class="container">
        <div class="row align-items-center">
            <!-- Left Side - FAQs Accordion -->
            <div class="col-lg-6 mb-4 mb-lg-0">
                <div class="faq-content">
                    <div class="section-header mb-4">
                        <h2 class="section-title">
                            <i class="fa-solid fa-circle-question"></i>
                            الأسئلة الشائعة
                        </h2>
                        <p class="section-subtitle">إجابات سريعة على الأسئلة الأكثر شيوعاً</p>
                    </div>

                    <div class="accordion" id="faqAccordion">
                        @forelse($faqs as $index => $faq)
                            <div class="accordion-item">
                                <h3 class="accordion-header">
                                    <button class="accordion-button {{ $index === 0 ? '' : 'collapsed' }}" 
                                            type="button" 
                                            data-bs-toggle="collapse" 
                                            data-bs-target="#faq{{ $faq->id }}" 
                                            aria-expanded="{{ $index === 0 ? 'true' : 'false' }}"
                                            aria-controls="faq{{ $faq->id }}">
                                        <span class="question-icon">
                                            <i class="fa-solid fa-question-circle"></i>
                                        </span>
                                        <span class="question-text">{{ $faq->question }}</span>
                                    </button>
                                </h3>
                                <div id="faq{{ $faq->id }}" 
                                     class="accordion-collapse collapse {{ $index === 0 ? 'show' : '' }}" 
                                     data-bs-parent="#faqAccordion">
                                    <div class="accordion-body">
                                        <div class="answer-content">
                                            {!! nl2br(e($faq->answer)) !!}
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @empty
                            <div class="empty-state text-center py-5">
                                <i class="fa-solid fa-circle-question fa-3x text-muted mb-3"></i>
                                <p class="text-muted">لا توجد أسئلة شائعة متاحة حالياً</p>
                            </div>
                        @endforelse
                    </div>
                </div>
            </div>

            <!-- Right Side - Image -->
            <div class="col-lg-6">
                <div class="faq-image-wrapper">
                    <div class="faq-image">
                        <img src="{{ asset('images/faq-illustration.svg') }}" 
                             alt="الأسئلة الشائعة" 
                             class="img-fluid"
                             onerror="this.src='data:image/svg+xml,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' width=\'500\' height=\'400\'%3E%3Crect fill=\'%23f0f0f0\' width=\'500\' height=\'400\'/%3E%3Ctext x=\'50%25\' y=\'50%25\' text-anchor=\'middle\' dy=\'.3em\' fill=\'%23999\' font-family=\'Arial\' font-size=\'20\'%3EFAQ Illustration%3C/text%3E%3C/svg%3E'">
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
/* FAQs Section */
.faqs-section {
    background: linear-gradient(135deg, #f8f9fa 0%, #ffffff 100%);
    position: relative;
    overflow: hidden;
}

.faqs-section::before {
    content: '';
    position: absolute;
    top: -50%;
    right: -50%;
    width: 100%;
    height: 100%;
    background: radial-gradient(circle, rgba(5, 85, 162, 0.05) 0%, transparent 70%);
    pointer-events: none;
}

/* Image Wrapper */
.faq-image-wrapper {
    position: relative;
    height: 100%;
    min-height: 400px;
    display: flex;
    align-items: center;
    justify-content: center;
}

.faq-image {
    position: relative;
    width: 100%;
    max-width: 500px;
    height: 400px;
    display: flex;
    align-items: center;
    justify-content: center;
}

.faq-image img {
    width: 100%;
    height: 100%;
    object-fit: contain;
    filter: drop-shadow(0 10px 30px rgba(0, 0, 0, 0.1));
}

/* Section Header */
.section-header {
    margin-bottom: 30px;
}

.section-title {
    font-size: 2.5rem;
    font-weight: 700;
    color: var(--secondary-Color);
    margin-bottom: 15px;
    display: flex;
    align-items: center;
    gap: 15px;
}

.section-title i {
    color: var(--secondary-Color);
    font-size: 2rem;
    animation: pulse-icon 2s ease-in-out infinite;
}

@keyframes pulse-icon {
    0%, 100% {
        transform: scale(1);
    }
    50% {
        transform: scale(1.1);
    }
}

.section-subtitle {
    color: #666;
    font-size: 1.1rem;
    margin: 0;
}

/* Accordion Styles */
.accordion {
    --bs-accordion-border-color: transparent;
    --bs-accordion-border-radius: 15px;
    --bs-accordion-inner-border-radius: 15px;
}

.accordion-item {
    border: none;
    margin-bottom: 15px;
    border-radius: 15px !important;
    overflow: hidden;
    box-shadow: 0 3px 15px rgba(0, 0, 0, 0.08);
    background: #ffffff;
    transition: all 0.3s ease;
}

.accordion-item:hover {
    box-shadow: 0 5px 25px rgba(0, 0, 0, 0.12);
    transform: translateY(-2px);
}

.accordion-button {
    background: #ffffff;
    color: var(--secondary-Color);
    font-weight: 600;
    padding: 20px 25px;
    border: none;
    font-size: 1.1rem;
    box-shadow: none;
    display: flex;
    align-items: center;
    gap: 15px;
}

.accordion-button:not(.collapsed) {
    background: var(--secondary-Color);
    color: #ffffff;
    box-shadow: none;
}

.accordion-button:not(.collapsed) .question-icon {
    color: #ffffff;
}

.accordion-button:focus {
    box-shadow: none;
    border: none;
    outline: none;
}

.accordion-button::after {
    margin-right: auto;
    margin-left: 0;
    background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16' fill='%230555a2'%3e%3cpath fill-rule='evenodd' d='M1.646 4.646a.5.5 0 0 1 .708 0L8 10.293l5.646-5.647a.5.5 0 0 1 .708.708l-6 6a.5.5 0 0 1-.708 0l-6-6a.5.5 0 0 1 0-.708z'/%3e%3c/svg%3e");
}

.accordion-button:not(.collapsed)::after {
    background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16' fill='%23ffffff'%3e%3cpath fill-rule='evenodd' d='M1.646 4.646a.5.5 0 0 1 .708 0L8 10.293l5.646-5.647a.5.5 0 0 1 .708.708l-6 6a.5.5 0 0 1-.708 0l-6-6a.5.5 0 0 1 0-.708z'/%3e%3c/svg%3e");
}

.question-icon {
    font-size: 1.5rem;
    color: var(--secondary-Color);
    transition: all 0.3s ease;
}

.question-text {
    flex: 1;
    text-align: right;
    line-height: 1.6;
}

.accordion-body {
    padding: 25px;
    background: #ffffff;
    color: #555;
    line-height: 1.8;
}

.answer-content {
    font-size: 1rem;
    color: #666;
}

/* Empty State */
.empty-state {
    padding: 60px 20px;
}

.empty-state i {
    opacity: 0.3;
}

/* Responsive */
@media (max-width: 992px) {
    .faq-image-wrapper {
        min-height: 300px;
    }

    .animated-image {
        height: 300px;
    }

    .section-title {
        font-size: 2rem;
    }
}

@media (max-width: 768px) {
    .section-title {
        font-size: 1.75rem;
    }

    .section-subtitle {
        font-size: 1rem;
    }

    .accordion-button {
        padding: 15px 20px;
        font-size: 1rem;
    }

    .accordion-body {
        padding: 20px;
    }

    .faq-image-wrapper {
        min-height: 250px;
    }

    .animated-image {
        height: 250px;
    }
}
</style>

