<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Frontend\HomeController;
use App\Http\Controllers\Frontend\CourseController;
use App\Http\Controllers\Frontend\ReviewController;
use App\Http\Controllers\Frontend\StudentController;
use App\Http\Controllers\Frontend\BlogController;



Route::get('/', [HomeController::class, 'index'])->name('frontend.home');
Route::get('/courses', [CourseController::class, 'index'])->name('frontend.courses.index');
Route::get('/courses/{slug}', [CourseController::class, 'show'])->name('frontend.courses.show');
Route::get('/reviews', [ReviewController::class, 'index'])->name('frontend.reviews.index');
Route::get('/reviews/create', [ReviewController::class, 'create'])->name('frontend.reviews.create')->middleware('auth');
Route::post('/reviews', [ReviewController::class, 'store'])->name('frontend.reviews.store')->middleware('auth');
Route::get('/students', [StudentController::class, 'index'])->name('frontend.students.index');
Route::get('/students/{id}', [StudentController::class, 'show'])->name('frontend.students.show');
Route::get('/contact', [HomeController::class, 'contact'])->name('frontend.contact');
Route::post('/contact', [HomeController::class, 'sendContact'])->name('frontend.contact.send');

// Blog Routes
Route::prefix('blog')->name('frontend.blog.')->group(function () {
    Route::get('/', [BlogController::class, 'index'])->name('index');
    Route::get('/search', [BlogController::class, 'search'])->name('search');
    Route::get('/category/{slug}', [BlogController::class, 'category'])->name('category');
    Route::get('/tag/{slug}', [BlogController::class, 'tag'])->name('tag');
    Route::get('/{slug}', [BlogController::class, 'show'])->name('show');
});
